/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.support;

import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.ExceptionMonitor;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFuture;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoFutureListener;
import com.alibaba.cs.shaded.com.alibaba.configserver.org.apache.mina.common.IoSession;
import java.util.ArrayList;
import java.util.List;

public class DefaultIoFuture
implements IoFuture {
    private final IoSession session;
    private final Object lock;
    private IoFutureListener firstListener;
    private List<IoFutureListener> otherListeners;
    private Object result;
    private boolean ready;

    public DefaultIoFuture(IoSession session) {
        this.session = session;
        this.lock = this;
    }

    public IoSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(long timeoutMillis) {
        long startTime = timeoutMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (waitTime <= 0L) {
                return this.ready;
            }
            do {
                try {
                    this.lock.wait(waitTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.ready) continue;
                return true;
            } while ((waitTime = timeoutMillis - (System.currentTimeMillis() - startTime)) > 0L);
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    @Deprecated
    protected void setValue(Object newValue) {
        this.setValue(newValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setValue(Object newValue, Object extra) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return false;
            }
            this.result = newValue;
            this.ready = true;
            this.onValueSet(newValue, extra);
            this.lock.notifyAll();
            this.notifyListeners();
            return true;
        }
    }

    protected void onValueSet(Object value, Object extra) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                if (this.firstListener == null) {
                    this.firstListener = listener;
                } else {
                    if (this.otherListeners == null) {
                        this.otherListeners = new ArrayList<IoFutureListener>(1);
                    }
                    this.otherListeners.add(listener);
                }
            } else {
                this.notifyListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (listener == this.firstListener) {
                this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
            } else if (this.otherListeners != null) {
                this.otherListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.firstListener != null) {
                this.notifyListener(this.firstListener);
                if (this.otherListeners != null) {
                    for (IoFutureListener l : this.otherListeners) {
                        this.notifyListener(l);
                    }
                }
            }
        }
    }

    private void notifyListener(IoFutureListener l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
    }
}

