/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.server;

import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianInput;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianOutput;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.SerializerFactory;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.server.HessianSkeleton;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.services.server.GenericService;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.services.server.Service;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.services.server.ServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HessianServlet
extends GenericServlet {
    private Class _homeAPI;
    private Object _homeImpl;
    private Class _objectAPI;
    private Object _objectImpl;
    private HessianSkeleton _homeSkeleton;
    private HessianSkeleton _objectSkeleton;
    private SerializerFactory _serializerFactory;

    public String getServletInfo() {
        return "Hessian Servlet";
    }

    public void setHomeAPI(Class api) {
        this._homeAPI = api;
    }

    public void setHome(Object home) {
        this._homeImpl = home;
    }

    public void setObjectAPI(Class api) {
        this._objectAPI = api;
    }

    public void setObject(Object object) {
        this._objectImpl = object;
    }

    public void setService(Object service) {
        this.setHome(service);
    }

    public void setAPIClass(Class api) {
        this.setHomeAPI(api);
    }

    public Class getAPIClass() {
        return this._homeAPI;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this._serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
        return this._serializerFactory;
    }

    public void setSendCollectionType(boolean sendType) {
        this.getSerializerFactory().setSendCollectionType(sendType);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String className;
            if (this._homeImpl == null) {
                Class homeClass;
                if (this.getInitParameter("home-class") != null) {
                    className = this.getInitParameter("home-class");
                    homeClass = this.loadClass(className);
                    this._homeImpl = homeClass.newInstance();
                    this.init(this._homeImpl);
                } else if (this.getInitParameter("service-class") != null) {
                    className = this.getInitParameter("service-class");
                    homeClass = this.loadClass(className);
                    this._homeImpl = homeClass.newInstance();
                    this.init(this._homeImpl);
                } else {
                    if (((Object)((Object)this)).getClass().equals(HessianServlet.class)) {
                        throw new ServletException("server must extend HessianServlet");
                    }
                    this._homeImpl = this;
                }
            }
            if (this._homeAPI == null) {
                if (this.getInitParameter("home-api") != null) {
                    className = this.getInitParameter("home-api");
                    this._homeAPI = this.loadClass(className);
                } else if (this.getInitParameter("api-class") != null) {
                    className = this.getInitParameter("api-class");
                    this._homeAPI = this.loadClass(className);
                } else if (this._homeImpl != null) {
                    this._homeAPI = this.findRemoteAPI(this._homeImpl.getClass());
                    if (this._homeAPI == null) {
                        this._homeAPI = this._homeImpl.getClass();
                    }
                }
            }
            if (this._objectImpl == null && this.getInitParameter("object-class") != null) {
                className = this.getInitParameter("object-class");
                Class objectClass = this.loadClass(className);
                this._objectImpl = objectClass.newInstance();
                this.init(this._objectImpl);
            }
            if (this._objectAPI == null) {
                if (this.getInitParameter("object-api") != null) {
                    className = this.getInitParameter("object-api");
                    this._objectAPI = this.loadClass(className);
                } else if (this._objectImpl != null) {
                    this._objectAPI = this._objectImpl.getClass();
                }
            }
            this._homeSkeleton = new HessianSkeleton(this._homeImpl, this._homeAPI);
            if (this._objectAPI != null) {
                this._homeSkeleton.setObjectClass(this._objectAPI);
            }
            if (this._objectImpl != null) {
                this._objectSkeleton = new HessianSkeleton(this._objectImpl, this._objectAPI);
                this._objectSkeleton.setHomeClass(this._homeAPI);
            } else {
                this._objectSkeleton = this._homeSkeleton;
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Class findRemoteAPI(Class implClass) {
        if (implClass == null || implClass.equals(GenericService.class)) {
            return null;
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        return this.findRemoteAPI(implClass.getSuperclass());
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return Class.forName(className, false, loader);
        }
        return Class.forName(className);
    }

    private void init(Object service) throws ServletException {
        if (service instanceof Service) {
            ((Service)service).init(this.getServletConfig());
        } else if (service instanceof Servlet) {
            ((Servlet)service).init(this.getServletConfig());
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!req.getMethod().equals("POST")) {
            res.setStatus(500, "Hessian Requires POST");
            PrintWriter out = res.getWriter();
            res.setContentType("text/html");
            out.println("<h1>Hessian Requires POST</h1>");
            return;
        }
        String serviceId = req.getPathInfo();
        String objectId = req.getParameter("id");
        if (objectId == null) {
            objectId = req.getParameter("ejbid");
        }
        ServiceContext.begin((ServletRequest)req, serviceId, objectId);
        try {
            ServletInputStream is = request.getInputStream();
            ServletOutputStream os = response.getOutputStream();
            HessianInput in = new HessianInput((InputStream)is);
            HessianOutput out = new HessianOutput();
            out.setSerializerFactory(this.getSerializerFactory());
            out.init((OutputStream)os);
            if (objectId != null) {
                this._objectSkeleton.invoke(in, out);
            } else {
                this._homeSkeleton.invoke(in, out);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        finally {
            ServiceContext.end();
        }
    }
}

