/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.client;

import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.client.HessianProxyFactory;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.client.HessianRuntimeException;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianOutput;
import com.alibaba.cs.shaded.com.alibaba.configserver.com.caucho.hessian.io.HessianProtocolException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HessianProxy
implements InvocationHandler {
    private HessianProxyFactory _factory;
    private URL _url;

    HessianProxy(HessianProxyFactory factory, URL url) {
        this._factory = factory;
        this._url = url;
    }

    public URL getURL() {
        return this._url;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return new Boolean(false);
            }
            HessianProxy handler = (HessianProxy)Proxy.getInvocationHandler(value);
            return new Boolean(this._url.equals(handler.getURL()));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._url.hashCode());
        }
        if (methodName.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (methodName.equals("getHessianURL")) {
            return this._url.toString();
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "[HessianProxy " + this._url + "]";
        }
        InputStream is = null;
        URLConnection conn = null;
        try {
            conn = this._factory.openConnection(this._url);
            conn.setRequestProperty("Content-Type", "text/xml");
            OutputStream os = null;
            try {
                os = conn.getOutputStream();
            }
            catch (Exception e) {
                throw new HessianRuntimeException(e);
            }
            HessianOutput out = this._factory.getHessianOutput(os);
            if (this._factory.isOverloadEnabled()) {
                methodName = args != null ? methodName + "__" + args.length : methodName + "__0";
            }
            out.call(methodName, args);
            os.flush();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                int code = 500;
                try {
                    code = httpConn.getResponseCode();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (code != 200) {
                    StringBuffer sb = new StringBuffer();
                    try {
                        int ch;
                        is = httpConn.getInputStream();
                        if (is != null) {
                            while ((ch = is.read()) >= 0) {
                                sb.append((char)ch);
                            }
                            is.close();
                        }
                        if ((is = httpConn.getErrorStream()) != null) {
                            while ((ch = is.read()) >= 0) {
                                sb.append((char)ch);
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new HessianRuntimeException(String.valueOf(e));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw new HessianProtocolException(sb.toString());
                }
            }
            is = conn.getInputStream();
            AbstractHessianInput in = this._factory.getHessianInput(is);
            Object object = in.readReply(method.getReturnType());
            return object;
        }
        catch (HessianProtocolException e) {
            e.printStackTrace();
            throw new HessianRuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
            catch (Throwable e) {}
        }
    }
}

