package com.taobao.config.client.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.List;


import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import com.taobao.config.common.protocol.UserDataGroupElement;
import com.taobao.config.common.protocol.utils.TransmitUtils;



public class ZipUtil {

    /**
     * жǷZIPʽֻҪ!ZIPԾΪ֧ѹ
     */
    static public boolean isZipContent(ProtocolPackage pp) {
        for (ProtocolElement item : pp) {
            if (item instanceof AttributeElement
                    && ((AttributeElement) item).name.equals(AttributeElement.ATTRIBUTE_ZIP)) {
                return true;
            }
        }
        return false;
    }

    /**
     * UserDataElementеѹݻԭݡ
     */
    static public List<Object> getPushDataFromZipContent(UserDataElement dataElement)
            throws IOException {
        byte[] zipBytes = (byte[]) dataElement.getActualData().get(0);
        byte[] rawBytes = TransmitUtils.unzip(zipBytes);
        final String jsonText = new String(rawBytes);
        if (StringUtils.EMPTY.equals(jsonText)) { // GSONѿбתΪ[]
            return Collections.emptyList();
        } else {
            return TransmitUtils.fromJSON(jsonText);
        }
    }

    /**
     * UserDataElementеѹݻԭݡ
     */
    static public List<Object> getPushDataFromZipContent(List<Object> data)
            throws IOException {
        byte[] zipBytes = (byte[]) data.get(0);
        byte[] rawBytes = TransmitUtils.unzip(zipBytes);
        final String jsonText = new String(rawBytes);
        if (StringUtils.EMPTY.equals(jsonText)) { // GSONѿбתΪ[]
            return Collections.emptyList();
        } else {
            return TransmitUtils.fromJSON(jsonText);
        }
    }
}
