package com.taobao.config.client.utils;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.middleware.logger.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/7/16 12:42
 */
public class ObserverDataUtils {
    static private final Logger log = ConfigClientLogger.getLogger(ObserverDataUtils.class);

    public static List<ObserverData> getObserverData(List<Object> datas, List<Map<String,String>> baseDatas){
        if(datas.size()!=baseDatas.size()){
            log.info("ObserverDataUtils.getObserverData datas.size("+datas.size() +
                    ") != baseDatas.size("+baseDatas.size()+"),return ObserverData without metaData");
            return getObserverData(datas);
        }
        List<ObserverData> observerDatas = new ArrayList<ObserverData>();
        for(int i=0;i<datas.size();i++) {
            ObserverData observerData = new ObserverData(datas.get(i));
            observerData.setBaseData(baseDatas.get(i));
            observerDatas.add(observerData);
        }
        return observerDatas;
    }


    public static List<Object> getDataFromObserverDataMap(Map<String,List<ObserverData>> baseDataMap) {
        if(baseDataMap==null){
            log.info("ObserverDataUtils.getDataFromObserverDataMap baseDataMap is null");
        }
        List<Object> resultDatas = new ArrayList<Object>();
        for(Map.Entry<String,List<ObserverData>> entry : baseDataMap.entrySet()) {
            List<ObserverData> observerDatas = entry.getValue();
            if(observerDatas!=null){
                List<Object> datas = getDataFromObserverData(observerDatas);
                resultDatas.addAll(datas);
            }
        }
        return resultDatas;
    }


    public static List<Object> getDataFromObserverData(List<ObserverData> baseDatas){
        if(baseDatas==null){
            log.info("ObserverDataUtils.getDataFromObserverData baseDatas is null");
        }
        List<Object> datas = new ArrayList<Object>();
        for(int i=0;i<baseDatas.size();i++) {
            ObserverData observerData = baseDatas.get(i);
            datas.add(observerData.getData());
        }
        return datas;
    }

    public static Map<String, List<ObserverData>> getObserverDataMapFromData(List<Object> datas){
        if(datas == null) {
            log.info("ObserverDataUtils.getObserverDataMapFromData datas is null");
        }
        Map<String, List<ObserverData>> resultMap = new HashMap<String, List<ObserverData>>();
        List<ObserverData> observerDatas = getObserverData(datas);
        resultMap.put(LocalConfigInfo.DEFAULT_IPGROUP, observerDatas);
        return resultMap;
    }

    private static List<ObserverData> getObserverData(List<Object> datas) {
        List<ObserverData> observerDatas = new ArrayList<ObserverData>();
        for(Object data : datas) {
            observerDatas.add(new ObserverData(data));
        }
        return observerDatas;
    }

}
