package com.taobao.config.client.utils;

import com.alibaba.configserver.google.gson.Gson;
import com.alibaba.configserver.google.gson.GsonBuilder;
import com.alibaba.configserver.google.gson.reflect.TypeToken;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.utils.StringUtils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/7/16 10:08
 */
public class JSONUtils {

    public static String toJSON(Map<String, List<ObserverData>> datas) {
        if (datas == null || datas.isEmpty()) {
            return StringUtils.EMPTY;
        }
        //List<Map<String, Object>> resultList= new Gson().fromJson(objList, new TypeToken<List<Map<String, Object>>>(){}.getType())
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(datas);
    }



    /**
     * JSONıзлͶ
     */
    public static Map<String,List<ObserverData>> dataWithMetafromJSON(String jsonText) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Map<String, List<ObserverData>> data = gson.fromJson(jsonText, new TypeToken<Map<String,List<ObserverData>>>() {}.getType());
        return data;
    }

}
