package com.taobao.config.client.utils;


import com.taobao.config.client.http.HttpResult;

import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/1/9 9:27
 */
public class HttpUtils {
    // serverӳʱsocketʱ
    static final int TIMEOUT = 5000;

    public static HttpResult invokeURL(String url) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection) new URL(url).openConnection();
            conn.setConnectTimeout(TIMEOUT);
            conn.setReadTimeout(TIMEOUT);
            conn.setRequestMethod("GET");
            conn.setInstanceFollowRedirects(false); //302ȥԶת
            conn.connect(); // TCP
            int respCode = conn.getResponseCode(); // ڲ
            String resp = null;
            if (200 == respCode) {
                resp = IOUtils.toString(conn.getInputStream(), null);
            } else {
                if(conn.getErrorStream()!=null){
                    resp = IOUtils.toString(conn.getErrorStream(), null);
                }
            }
            return new HttpResult(respCode, resp);
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }


    public static List<String> httpResultLines(HttpResult httpResult) throws IOException {
        List<String> lines = IOUtils.readLines(new StringReader(httpResult.content));
        List<String> result = new ArrayList<String>(lines.size());
        for (String line : lines) {
            if (null == line || line.trim().isEmpty()) {
                continue;
            } else {
                // TODO
                result.add(line.trim());
            }
        }
        return result;
    }
}

