package com.taobao.config.client.utils;

import java.util.Arrays;
import java.util.Iterator;


/**
 * ѶΪһĹߡ
 */
public class FluentIterator implements Iterator<Object> {

    static public Iterator<?> asIterator(Iterator<?>... iterators) {
        return new FluentIterator(iterators);
    }
    
    @Override
    public boolean hasNext() {
        Iterator<?> currIter = iterArray[idx];
        if (currIter.hasNext()) {
            return true;
        } else if (idx == iterArray.length - 1) {
            return false;
        } else {
            idx++;
            return hasNext();
        }
    }

    @Override
    public Object next() {
        return iterArray[idx].next();
    }

    @Override
    public void remove() {
        iterArray[idx].remove();
    }
    
    private FluentIterator(Iterator<?>[] iters) {
    	if(null == iters) {
    		iterArray = new Iterator<?>[0];
    	} else {
    		iterArray = Arrays.copyOf(iters, iters.length); //defensive copy
    	}
    }
    
    final Iterator<?>[] iterArray;
    int idx = 0;
}
