package com.taobao.config.client.utils;

import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.identify.CredentialService;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolPackage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/7/16 7:44
 */
public class AttributeUtils {


    public static Map<String,Integer> getMap(String appName, String machineGroup, String site, String unit, String ipGroup, List<String> strBufferPool){
        Map<String,Integer> map = new HashMap<String,Integer>(12);
        map.put(AttributeElement.ATTRIBUTE_APP, getIntFormStrBufferPool(appName,strBufferPool));
        map.put(AttributeElement.ATTRIBUTE_MACHINEGROUP, getIntFormStrBufferPool(machineGroup,strBufferPool));
        map.put(AttributeElement.ATTRIBUTE_SITE, getIntFormStrBufferPool(site,strBufferPool));
        map.put(AttributeElement.ATTRIBUTE_UNIT, getIntFormStrBufferPool(unit,strBufferPool));
        map.put(AttributeElement.ATTRIBUTE_IPGROUP, getIntFormStrBufferPool(ipGroup,strBufferPool));
        return map;
    }

    public static Integer getIntFormStrBufferPool(String str, List<String> strBufferPool) {
        if(StringUtils.isBlank(str)) {
            return null;
        }
        for(int i = 0; i < strBufferPool.size(); i++) {
            String strBuffer = strBufferPool.get(i);
            if(strBuffer.equals(str)){
                return i;
            }
        }
        strBufferPool.add(str);
        return strBufferPool.size()-1;
    }

    public static void setInstanceMetaInPackage(ProtocolPackage packagee, InstanceMetaData instanceMetaData) {
        if(instanceMetaData!=null){
            if(StringUtils.isNotBlank(instanceMetaData.getAppName())) {
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_APP, instanceMetaData.getAppName()));
            }else{
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_APP, AppNameUtils.getAppName()));
            }
            if(StringUtils.isNotBlank(instanceMetaData.getMachineGroup())){
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_MACHINEGROUP, instanceMetaData.getMachineGroup()));

            }
            if(StringUtils.isNotBlank(instanceMetaData.getUnit())){
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_UNIT, instanceMetaData.getUnit()));

            }
            if(StringUtils.isNotBlank(instanceMetaData.getSite())){
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_SITE, instanceMetaData.getSite()));

            }
            if(StringUtils.isNotBlank(instanceMetaData.getIpGroup())){
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_IPGROUP, instanceMetaData.getIpGroup()));
            }
            if(StringUtils.isNotBlank(instanceMetaData.getAccessKey())){
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_SPAS_ACCESSKEY, instanceMetaData.getAccessKey()));
            } else {
                packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_SPAS_ACCESSKEY, CredentialService.getInstance().getCredential().getAccessKey()));
            }
        } else {
            packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_SPAS_ACCESSKEY, CredentialService.getInstance().getCredential().getAccessKey()));
            packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_APP, AppNameUtils.getAppName()));
        }
    }
}
