
package com.taobao.config.client.tools;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;

/**
 * 
 * @author caogu.wyp
 *
 */
@Deprecated
public final class CheckService {

    private static Logger logger = LoggerFactory.getLogger(CheckService.class);

    public static void checkJarConflict() throws RuntimeException {
        try {
            //gson ,gson Ѿ´Ҫټ
            //checkJarConflict("com/google/gson/JsonObject.class", "gson-2.2.jar");
            //mina   mina-core-1.1.5.bugfix.jar or mina-core-1.1.5.bugfix-xxxxxx.jar
            //mina ´
            //checkJarConflict("org/apache/mina/handler/chain/IoHandlerChain.class", "mina-core-1.1.5.bugfix");
        } catch (Throwable e) {
            logger.error("%s", "Check Jar Conflict Error", e);
            throw new RuntimeException("Check Jar Conflict", e);
        }
        logger.info("Check jar conflict success!");
    }

    private static void checkJarConflict(String name, String jarFileName) throws IOException {
        Enumeration<URL> urls = CheckService.class.getClassLoader().getResources(name);
        if (!urls.hasMoreElements()) {
            throw new RuntimeException("Can not find " + name);
        }
        List<String> paths = new ArrayList<String>();
        boolean includeCorrectJar = false;
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String path = url.getPath();
            if (path.contains(jarFileName)) {
                includeCorrectJar = true;
            }
            paths.add(path);
        }
        StringBuilder pathStr = new StringBuilder();
        StringBuilder errorMessage = new StringBuilder();
        for (String s : paths) {
            pathStr.append(s).append("\n");
        }
        if (!includeCorrectJar) {
            errorMessage.append("ERROR: You must use ").append(jarFileName).append("\n");
            errorMessage.append("Check Result : " + "\n" + pathStr.toString());
            throw new RuntimeException(errorMessage.toString());
        }
        if (paths.size() > 1) {
            errorMessage.append("ERROR: Multiple jar files ,You should use ").append(jarFileName).append("\n");
            errorMessage.append("Check Result : " + "\n" + pathStr.toString());
            throw new RuntimeException(errorMessage.toString());
        }
    }
}
