
package com.taobao.config.client.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.ConnectionProxy;
import com.taobao.config.client.DefaultPublisher;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.ServerListManager;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberDataObserver;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.SubscriberRegistration;
import com.taobao.config.client.exception.ConfigClientException;
import com.taobao.config.client.http.HttpResult;
import com.taobao.config.client.utils.HttpUtils;
import com.taobao.config.common.protocol.utils.TransmitUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Connection;

public class ConfigClientService {

    static private final Logger log = ConfigClientLogger.getLogger(ConfigClientService.class);

    public static String getClientConnections() {
        //ȡͻ˺ͷ˵
        List<String> connectionStrList = new ArrayList<String>();
        for (Connection connection : ConnectionProxy.allConnection.keySet()) {
            String localAddress = connection.getClient().getConnection().getLocalAddress();
            int localPort = connection.getClient().getConnection().getLocalPort();
            String remoteAddress = connection.getClient().getConnection().getRemoteAddress();
            int remotePort = connection.getClient().getConnection().getRemotePort();
            connectionStrList.add(localAddress + ":" + localPort + " " + remoteAddress + ":" + remotePort);
        }
        return TransmitUtils.toJSON(connectionStrList);
    }

    public static String getAllPubInfo() {
        List<String> pubDataIds = new ArrayList<String>();
        Iterator<DefaultPublisher<?>> iterator = PublisherRegistrar.AllPublishers().iterator();
        while (iterator.hasNext()) {
            DefaultPublisher<?> pub = iterator.next();
            String dataId = pub.getRegistration().getDataId();
            String groupName = pub.getRegistration().getGroup();
            //String tenantId = pub.getRegistration().getTenant();
            //String datumId = pub.getRegistration().getDatumId();
            pubDataIds.add("DataId:" + dataId + " GroupName:" + groupName);
        }
        return TransmitUtils.toJSON(pubDataIds);
    }

    public static String getAllsubInfo() {
        List<String> subDataInfoList = new ArrayList<String>();
        for (Subscriber sub : SubscriberRegistrar.getSubs()) {
            subDataInfoList.add("DataId:" + sub.getRegistration().getDataId() + " GroupName:" + sub.getRegistration().getGroup());
        }
        return TransmitUtils.toJSON(subDataInfoList);
    }

    public static String getSubData(String dataId, String groupName) {
        for (DefaultSubscriber sub : SubscriberRegistrar.AllDefaultSubs()) {
            if (sub.getRegistration().getDataId().equals(dataId) && sub.getRegistration().getGroup().equals(groupName)) {
                return TransmitUtils.toJSON(sub.getData());
            }
        };
        return "";
    }

    public static String getSubObserverData(String dataId, String groupName) {
        for (DefaultSubscriber sub : SubscriberRegistrar.AllDefaultSubs()) {
            if (sub.getRegistration().getDataId().equals(dataId) && sub.getRegistration().getGroup().equals(groupName)) {
                return TransmitUtils.toJsonFromMap(sub.getObserverDataGroups());
            }
        };
        return "";
    }

    public static String getWeightValue(String dataId, String groupName) {
        for (DefaultSubscriber sub : SubscriberRegistrar.AllDefaultSubs()) {
            if (sub.getRegistration().getDataId().equals(dataId) && sub.getRegistration().getGroup().equals(groupName)) {
                return TransmitUtils.toJsonFromMap(sub.getWeightValue());
            }
        };
        return "";
    }

    public static String getHealthStatus() {
        //ԼȥһݣзأΪǽ
        final CountDownLatch latch = new CountDownLatch(1);
        boolean isSucceses = false;
        SubscriberRegistration subR = new SubscriberRegistration("ConfigClientHealthCheck", "ConfigClientHealthCheck");
        Subscriber sb = SubscriberRegistrar.register(subR);
        sb.setDataObserver(new SubscriberDataObserver.NewDataObserver() {

            @Override
            public void onInitialLocalData(List<Object> data) {}

            @Override
            public void handleData(String dataId, List<Object> data) {
                latch.countDown();
            }
        });
        try {
            isSucceses = latch.await(6000, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        SubscriberRegistrar.unregister(sb);
        return isSucceses ? "UP" : "DOWN";
    }

    public static String getAllEnvServerlist() {
        //ÿserverlistManger棬вͬserverlistбг
        Map<String, List<String>> datas = new HashMap<String, List<String>>();
        for (ServerListManager serverListManager : ConnectionProxy.allConnection.values()) {
            datas.put(serverListManager.addressServerUrl(serverListManager.getCenter()), serverListManager.queryServerlist());
        }
        return TransmitUtils.toJsonFromMap(datas);
    }

    public static boolean setNoCachePersist(boolean isNoCache) {
        log.info("[ConfigClientService] setNoCachePersist set "+ isNoCache);
        ConfigClientSetting.setNotCachePersist(isNoCache);
        return isNoCache == ConfigClientSetting.isNotCachePersist();
    }

    public static boolean setNotRollSnapshot(boolean isNotRoll) {
        log.info("[ConfigClientService] setNotRollSnapshot set "+ isNotRoll);
        ConfigClientSetting.setNotRollSnapshot(isNotRoll);
        return isNotRoll == ConfigClientSetting.isNotRollSnapshot();
    }

    /**
     * ͬȡipĻ־
     * @param ip
     *
     * @return
     * @throws ConfigClientException
     * if http result code not 200, throw ConfigClientExcetion(code=Http code)
     * if http result IoException, throw ConfigClientExcetion(code=getEnvByIp-ioE)
     */
    public static String getEnvByIp(String ip) throws ConfigClientException {
        String domain = ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort();
        String url = "http://" + domain + "/env?clientIP=" + ip;
        try {
            HttpResult httpResult = HttpUtils.invokeURL(url);
            if (200 == httpResult.code) {
                List<String> envs = HttpUtils.httpResultLines(httpResult);
                if (envs != null || !envs.isEmpty()) {
                    return envs.get(0);
                } else {
                    ConfigClientLogger.getLog().warn("[getEnvByIp] empty exception, " + url);
                    return "";
                }
            } else {
                ConfigClientLogger.getLog().error("%s", "[getEnvByIp] failed to get Env from " + url + ", error code " + httpResult.code);
                throw new ConfigClientException(String.valueOf(httpResult.code), "http invoke error code is" + httpResult.code);
            }
        } catch (IOException e) {
            ConfigClientLogger.getLog().warn("[getEnvByIp] exception, " + url + ", " + e.toString(), e);
            throw new ConfigClientException("getEnvByIp-ioE", "http invoke error ", e);
        }
    }



}
