
package com.taobao.config.client.remoting;

import java.util.concurrent.Executor;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientWorker;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.util.DIYExecutor;

/**
 * յİ
 * 
 * @author caogu.wyp
 * 
 */
public class ConnectionRequestProcessor implements RequestProcessor<ProtocolPackage> {

    private static final Logger logger = ConfigClientLogger.getLogger(ConnectionRequestProcessor.class);
    private ConfigClientWorker configClientWorker;

    public ConnectionRequestProcessor(ConfigClientWorker configClientWorker) {
        this.configClientWorker = configClientWorker;
    }

    public void handleRequest(ProtocolPackage appRequest, AppResponseOutput connResp) {
        if (configClientWorker.getMailbox().offer(appRequest)) {
            configClientWorker.signal();
            connResp.write(new ProtocolPackage());
        } else {
            logger.error("%s", "[Global] Push message discarded 'cause mailbox overflow.");
        }
    }

    public Executor getExecutor() {
        return DIYExecutor.getInstance();
    }

    public Class<ProtocolPackage> interest() {
        return ProtocolPackage.class;
    }

    public void onRejectedExecutionException(final ProtocolPackage packagee, final AppResponseOutput out) {}
}
