
package com.taobao.config.client.remoting;

import java.util.Iterator;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientWorker;
import com.taobao.config.client.DefaultPublisher;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener.ConnectionLifecycleListener;

/**
 * ConfigServer
 * 
 * @author caogu.wyp
 * 
 */
public class ConnectionListener implements ConnectionLifecycleListener {

    private static final Logger logger = ConfigClientLogger.getLogger(ConnectionListener.class);
    private ConfigClientWorker configClientWorker;

    public ConnectionListener(ConfigClientWorker configClientWorker) {
        this.configClientWorker = configClientWorker;
    }

    @Override
    public void connectionClosed(Connection conn) {
        logger.warn("[Global] Server connection is closed just recently [" + conn + "] , Will try reconnecting soon or it has been reconnected");
        for (Iterator<DefaultPublisher<?>> iter = PublisherRegistrar.publisherIterator(); iter.hasNext();) {
            DefaultPublisher<?> pub = iter.next();
            if (pub.getServerListManager() == configClientWorker.getServerListManager()) {
                logger.info("[Re-Registering] Publisher dataId=" + pub.getDataId() + ", clientId=" + pub.getClientId());
                pub.onServerDisconnected();
            }
        }
        for (Iterator<DefaultSubscriber> iter = SubscriberRegistrar.subscriberIterator(); iter.hasNext();) {
            DefaultSubscriber sub = iter.next();
            if (sub.getServerListManager() == configClientWorker.getServerListManager()) {
                logger.info("[Re-Registering] Subcriber dataId=" + sub.getDataId() + ", clientId=" + sub.getClientId());
                sub.onServerDisconnected();
            }
        }
        logger.info("[Global] Removing Server connection [" + conn + "]");
    }

    public void connectionOpened(Connection conn) {}
}
