
package com.taobao.config.client.processor;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcType;
import com.taobao.config.client.utils.ObserverDataUtils;
import com.taobao.config.client.utils.ZipUtil;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import com.taobao.config.common.protocol.UserDataGroupElement;
import com.taobao.remoting.util.LogConstants;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class UserDataGroupElementProcessor extends ProtocolElementProcessor {

    private static final int DATUM_LOG_TRUNCATION_SIZE = 256;

    @Override
    void process(ProtocolElement input, ProtocolPackage pp) {
        UserDataGroupElement dataGroupElement = (UserDataGroupElement) input;
        final String dataId = dataGroupElement.dataId;
        final Revision revision = dataGroupElement.revision;
        String[] clientIds = processClientId(dataGroupElement.clientIds, dataId);

        Map<String, List<ObserverData>> dataGroup = null;
        try {
            dataGroup = getDataList(dataId, revision, dataGroupElement);
        } catch (IOException e) {
            log.error("%s", "[GroupData-received] but zip format error, dataId=" + dataGroupElement.dataId + ", clientIds=" + dataGroupElement.clientIds);
            return;
        }
        if (revision == null || dataId == null || dataGroup == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataGroupElement!");
            return;
        }

        List<DefaultSubscriber> subscribers = getSubscribers(clientIds, dataId);
        boolean isSpasAccesss = checkProtocolElement(pp);

        for (DefaultSubscriber subscriber : subscribers) {
            if(!ConfigClientSetting.isNotCachePersist() && !ConfigClientSetting.isTimerCachePersist()) {
                CachePersist.save(dataId, subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), dataGroup, subscriber.getServerListManager().getEnv());
            }
            if (!isSpasAccesss) {
                //spas ֤ʧܣserver˻ᴫյlist֪ͨclient˻صҪӡerror־ѣͬʱcacheÿ
                String errorMessage = "[GroupData-received] spas-authentication-failed!" + " dataId:" + dataId + " revision:" + revision;
                log.error("%s", errorMessage);
                ExcEventDispatch.fireEvent(new ExcEvent(subscriber.getRegistration().getDataId(),//
                        subscriber.getRegistration().getGroup(),//
                        subscriber.getRegistration().getTenant(), //  
                        ExcType.SUB_PERMISSION,//
                        errorMessage));
            } else {
                //֪ͨ
                subscriber.update(revision, null, dataGroup);
            }
        }
    }

    private boolean checkProtocolElement(ProtocolPackage pp) {
        boolean isSpasAccesss = true;
        for (ProtocolElement elementItem : pp) {
            if (elementItem instanceof AttributeElement) {
                AttributeElement attriItem = (AttributeElement) elementItem;
                if (attriItem.getName().equals(AttributeElement.ATTRIBUTE_SPAS_ACCESSKEY)) {
                    isSpasAccesss = false;
                }
            }
        }
        return isSpasAccesss;
    }

    private List<DefaultSubscriber> getSubscribers(String[] clientIds, String dataId) {
        List<DefaultSubscriber> subscribers = new ArrayList<DefaultSubscriber>();
        for (final String clientId : clientIds) {
            if (clientId == null || clientId.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in UserDataGroupElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientId);
                if (null == subscriber) {
                    try {
                        Thread.sleep(10L);
                    } catch (Exception e) {
                        log.error("%s", e.toString(), e);
                    }
                }
            }
            if (null == subscriber) {
                log.warn(LogConstants.PREFIX_IMPORTANT + "[GroupData-subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientId + ")");
                continue;
            }
            subscribers.add(subscriber);
        } // end for
        return subscribers;
    }

    private String[] processClientId(String[] clientIds, final String dataId) {
        // Before v1.3, server is not giving us clientIds, so we should search all clients within this data ID.
        // This leads to the bug of "cross-group data overwrite", see JIRA issue: CONFIGSERVER-73
        if (clientIds != null && clientIds.length == 0) {
            log.error("%s","[Protocol] Empty client ID list in UserDataElement, try searching clients locally.");
            clientIds = null;
        }
        if (clientIds == null) {
            final List<DefaultSubscriber> subscribers = SubscriberRegistrar.findByDataId(dataId);
            clientIds = new String[subscribers.size()];
            int i = 0;
            for (final DefaultSubscriber subscriber : subscribers)
                clientIds[i++] = subscriber.getClientId();
        }
        return clientIds;
    }
//
//    private List<Object> getDataList(String dataId, Revision revision, UserDataGroupElement userDataGroupElement) throws IOException {
//
//        Map<String,List<Object>> ipGroupDataMap = userDataGroupElement.getActualData();
//        Map<String,Boolean> ipGroupIsGzip = userDataGroupElement.getIpGroupisGzipMap();
//        List<Object> allData = new ArrayList<Object>();
//        for(Map.Entry<String, List<Object>> entry : ipGroupDataMap.entrySet()) {
//            List<Object> data = null;
//            String key = entry.getKey();
//            List<Object> ipGroupData = entry.getValue();
//            boolean isGzip = ipGroupIsGzip.get(key);
//            if (isGzip) {
//                try {
//                    data = ZipUtil.getPushDataFromZipContent(ipGroupData);
//                } catch (IOException e) {
//                    throw e;
//                }
//            } else {
//                data = ipGroupData;
//            }
//            allData.add(data);
//        }
//
//        //Log
//        if (allData == null || allData.size() < 1) {
//            log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Empty)");
//        } else {
//            if (allData.size() != userDataGroupElement.size()) {
//                log.info("[Internal] Some unrecognized or corrupted data may be dropped." + " (Reported: " + userDataGroupElement.size() + ", Actual: " + allData.size() + "). ipGroupIsGzip="+ipGroupIsGzip);
//            }
//            // Peek a sample for logging object type.
//            final Object sample = allData.get(0);
//            if (sample instanceof String) {
//                String slug = (String) sample;
//                if (slug.length() > DATUM_LOG_TRUNCATION_SIZE)
//                    slug = slug.substring(0, DATUM_LOG_TRUNCATION_SIZE) + " ...";
//                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + allData.size() + ", ipGroupIsGzip="+ipGroupIsGzip + ", String[0]: " + slug + ")");
//            } else {
//                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + allData.size() + ", Class[0]: " + sample.getClass().getSimpleName() + ")");
//            }
//        }
//        return allData;
//    }


    private Map<String, List<ObserverData>> getDataList(String dataId, Revision revision, UserDataGroupElement userDataGroupElement) throws IOException {

        Map<String,List<Object>> ipGroupDataMap = userDataGroupElement.getActualData();
        Map<String,Boolean> ipGroupIsGzip = userDataGroupElement.getIpGroupisGzipMap();
        Map<String,Integer> ipGroupDataSizeMap = userDataGroupElement.ipGroupDataSize;
        int reportedDataSize = 0;
        int dataSize = 0;

        /** ѹ **/
        Map<String,List<Object>> allData = new HashMap<String, List<Object>>();
        for(Map.Entry<String, List<Object>> entry : ipGroupDataMap.entrySet()) {
            List<Object> data = null;
            String key = entry.getKey();
            List<Object> ipGroupData = entry.getValue();
            Boolean isGzip = ipGroupIsGzip.get(key);
            if (isGzip!=null && isGzip) {
                try {
                    data = ZipUtil.getPushDataFromZipContent(ipGroupData);
                } catch (IOException e) {
                    throw e;
                }
            } else {
                data = ipGroupData;
            }
            if(data!=null){
                dataSize = dataSize + data.size();
            }
            if(ipGroupDataSizeMap != null){
                Integer reDataSize = ipGroupDataSizeMap.get(key);
                if(reDataSize!=null){
                    reportedDataSize = reportedDataSize + reDataSize;
                }
            }
            allData.put(key, data);
        }

        /**  **/
        Map<String,List<ObserverData>> resultData = new HashMap<String, List<ObserverData>>();
        for(Map.Entry<String, List<Object>> entry : allData.entrySet()) {
            String key = entry.getKey();
            List<Object> datas = entry.getValue();
            List<Map<String, String>> metaData = userDataGroupElement.getIpGroupBaseData(key);
            List<ObserverData> observerDataList = new ArrayList<ObserverData>();
            if(datas!=null && metaData!=null){
                if(datas.size()!=metaData.size()){
                    log.info("UserDataGroupElementProcessor datas.size("+datas.size() +
                            ") != metaData.size("+metaData.size()+"),dataId="+dataId+", ipgroup="+key);
                }
                observerDataList = ObserverDataUtils.getObserverData(datas, metaData);
            }
            resultData.put(key, observerDataList);
        }

        //Log
        if (resultData == null || dataSize < 1) {
            log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Empty)");
        } else {
            if (dataSize != reportedDataSize) {
                log.info("[Internal] Some unrecognized or corrupted data may be dropped." + " (Reported: " + reportedDataSize + ", Actual: " + dataSize + "). ipGroupIsGzip="+ipGroupIsGzip);
            }
            // Peek a sample for logging object type.
            ObserverData observerData = null;
            for(Map.Entry<String,List<ObserverData>> entry :resultData.entrySet()){
                List<ObserverData> observerDataList = entry.getValue();
                if(observerDataList!=null && observerDataList.size()>0){
                    observerData = observerDataList.get(0);
                    break;
                }
            }
            final Object sample = (observerData!=null ? observerData.getData() : null);
            if (sample instanceof String) {
                String slug = (String) sample;
                if (slug.length() > DATUM_LOG_TRUNCATION_SIZE)
                    slug = slug.substring(0, DATUM_LOG_TRUNCATION_SIZE) + " ...";
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + resultData.size() + ", ipGroupIsGzip="+ipGroupIsGzip + ", String[0]: " + slug + ")");
            } else {
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + resultData.size() + ", Class[0]: " + sample.getClass().getSimpleName() + ")");
            }
        }
        return resultData;
    }
}
