
package com.taobao.config.client.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientSetting;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcType;
import com.taobao.config.client.utils.ZipUtil;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import com.taobao.remoting.util.LogConstants;


public class UserDataElementProcessor extends ProtocolElementProcessor {

    private static final int DATUM_LOG_TRUNCATION_SIZE = 256;

    @Override
    void process(ProtocolElement input, ProtocolPackage pp) {
        UserDataElement element = (UserDataElement) input;
        final String dataId = element.dataId;
        final Revision revision = element.revision;
        String[] clientIds = processClientId(element.clientIds, dataId);
        boolean isGzip = ZipUtil.isZipContent(pp);

        List<Object> data = null;
        try {
            data = getDataList(isGzip, dataId, revision, element);
        } catch (IOException e) {
            log.error("%s", "[Data-received] but zip format error, dataId=" + element.dataId + ", clientIds=" + element.clientIds);
            return;
        }
        if (revision == null || dataId == null || data == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataElement!");
            return;
        }
        List<DefaultSubscriber> subscribers = getSubscribers(clientIds, dataId);
        boolean isSpasAccesss = checkProtocolElement(pp);
        for (DefaultSubscriber subscriber : subscribers) {
            // ǲҪ̣߶ʱ̲Ҫʵʱ
            //if(!ConfigClientSetting.isNotCachePersist() || !ConfigClientSetting.isTimerCachePersist()) {
                CachePersist.save(dataId, subscriber.getRegistration().getGroup(), subscriber.getRegistration().getTenant(), data, subscriber.getServerListManager().getEnv());
            //}
            if (!isSpasAccesss) {
                //spas ֤ʧܣserver˻ᴫյlist֪ͨclient˻صҪӡerror־ѣͬʱcacheÿ
                String errorMessage = "[Data-received] spas-authentication-failed!" + " dataId:" + dataId + " revision:" + revision;
                log.error("%s", errorMessage);
                ExcEventDispatch.fireEvent(new ExcEvent(subscriber.getRegistration().getDataId(),//
                        subscriber.getRegistration().getGroup(),//
                        subscriber.getRegistration().getTenant(), //  
                        ExcType.SUB_PERMISSION,//
                        errorMessage));
            } else {
                //֪ͨ
                subscriber.update(revision, data, null);
            }
        }
    }

    private boolean checkProtocolElement(ProtocolPackage pp) {
        boolean isSpasAccesss = true;
        for (ProtocolElement elementItem : pp) {
            if (elementItem instanceof AttributeElement) {
                AttributeElement attriItem = (AttributeElement) elementItem;
                if (attriItem.getName().equals(AttributeElement.ATTRIBUTE_SPAS_ACCESSKEY)) {
                    isSpasAccesss = false;
                }
            }
        }
        return isSpasAccesss;
    }

    private List<DefaultSubscriber> getSubscribers(String[] clientIds, String dataId) {
        List<DefaultSubscriber> subscribers = new ArrayList<DefaultSubscriber>();
        for (final String clientId : clientIds) {
            if (clientId == null || clientId.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in UserDataElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientId);
                if (null == subscriber) {
                    try {
                        Thread.sleep(10L);
                    } catch (Exception e) {
                        log.error("%s", e.toString(), e);
                    }
                }
            }
            if (null == subscriber) {
                log.warn(LogConstants.PREFIX_IMPORTANT + "[subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientId + ")");
                continue;
            }
            subscribers.add(subscriber);
        } // end for
        return subscribers;
    }

    private String[] processClientId(String[] clientIds, final String dataId) {
        // Before v1.3, server is not giving us clientIds, so we should search all clients within this data ID.
        // This leads to the bug of "cross-group data overwrite", see JIRA issue: CONFIGSERVER-73
        if (clientIds != null && clientIds.length == 0) {
            log.error("%s","[Protocol] Empty client ID list in UserDataElement, try searching clients locally.");
            clientIds = null;
        }
        if (clientIds == null) {
            final List<DefaultSubscriber> subscribers = SubscriberRegistrar.findByDataId(dataId);
            clientIds = new String[subscribers.size()];
            int i = 0;
            for (final DefaultSubscriber subscriber : subscribers)
                clientIds[i++] = subscriber.getClientId();
        }
        return clientIds;
    }

    private List<Object> getDataList(boolean isGzip, String dataId, Revision revision, UserDataElement element) throws IOException {
        List<Object> data = null;
        if (isGzip) {
            try {
                data = ZipUtil.getPushDataFromZipContent(element);
            } catch (IOException e) {
                throw e;
            }
        } else {
            data = element.getActualData();
        }
        //Log
        if (data == null || data.size() < 1) {
            log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Empty)");
        } else {
            if (data.size() != element.size() && !isGzip) {
                log.info("[Internal] Some unrecognized or corrupted data may be dropped." + " (Reported: " + element.size() + ", Actual: " + data.size() + ")");
            }
            // Peek a sample for logging object type.
            final Object sample = data.get(0);
            if (sample instanceof String) {
                String slug = (String) sample;
                if (slug.length() > DATUM_LOG_TRUNCATION_SIZE)
                    slug = slug.substring(0, DATUM_LOG_TRUNCATION_SIZE) + " ...";
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + data.size() + ", gzip=" + isGzip + ", String[0]: " + slug + ")");
            } else {
                log.info("[Data-received] (ID: " + dataId + ", Revision: " + revision + ", Count: " + data.size() + ", Class[0]: " + sample.getClass().getSimpleName() + ")");
            }
        }
        return data;
    }
}
