package com.taobao.config.client.processor;

import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.UserDataElement;
import com.taobao.config.common.protocol.weight.RulesElement;
import com.taobao.config.common.utils.StringUtils;
import com.taobao.remoting.util.LogConstants;

import java.util.List;
import java.util.Map;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/1/16 5:12
 */
public class RulesElementProcessor extends ProtocolElementProcessor {

    @Override
    public void process(ProtocolElement input, ProtocolPackage pp) {
        RulesElement element = (RulesElement)input;

        String dataId = element.getDataId();
        String clientId = element.getClientId();
        /** ӡȨ־*/
        log.info(LogConstants.PREFIX_IMPORTANT + "[weightRule-received :] (DataID: " + dataId + " clientId:"+ clientId +" weightValueSize:" + element.getValues().size());

        String[] clientIds;
        if (StringUtils.isBlank(clientId)) {
            log.error("%s", "[Protocol] Empty client ID list in RulesElement, try searching clients locally.");
            clientIds = null;
        } else {
            clientIds = new String[] {clientId};
        }
        /** dataIdΪգϷʽ(ϵķʽǴuserDataElementд)ȥȡdataId */
        if(dataId == null) {
            /** ȡͬpackage±ߵUserDataElement */
            UserDataElement userDataElement = getUserDataElement(pp);
            /** ûdataIdûUserDataElement ǲ*/
            if(userDataElement == null) {
                log.error("%s", "[Protocol] Protocol error in dataId null and NO userDataElement in ProtocolPackage");
                return;
            }
            final String userDataElementDataId = userDataElement.dataId;
            dataId = userDataElementDataId;
        }
        /** Уһ ǷΪ*/
        if (dataId == null) {
            log.error("%s", "[Protocol] Protocol error in parsing UserDataElement and RulesElement!");
            return;
        }

        if (clientIds == null) {
            List<String> clientIdList = SubscriberRegistrar.findClientIdsByDataId(dataId);
            clientIds = (String[]) clientIdList.toArray(new String[clientIdList.size()]);
        }

        for (final String clientIdValue : clientIds) {
            if (clientIdValue == null || clientIdValue.length() <= 0) {
                log.error("%s", "[Protocol] Null or empty client ID in RulesElement.");
                continue;
            }
            DefaultSubscriber subscriber = null;
            for (int failCount = 0; null == subscriber && failCount < 3; ++failCount) {
                subscriber = SubscriberRegistrar.find(clientIdValue);
                if (subscriber == null) {
                    try {
                        Thread.sleep(10L);
                    } catch (Exception e) {
                        log.error("%s", e.toString(), e);
                    }
                }
            }
            if (null != subscriber) {
                if (null != element) {
                    if(subscriber.setWeightValue(element.getValues())){
                        subscriber.notifyObServer();
                    }
                }
            } else {
                log.warn(LogConstants.PREFIX_IMPORTANT + "[subscriber-not-found] (DataID: " + dataId + ", ClientID:" + clientIdValue + ")");
            }
        }
    }

    private UserDataElement getUserDataElement(ProtocolPackage pp) {
        for (ProtocolElement item : pp) {
            if (item instanceof UserDataElement) {
                return (UserDataElement) item;
            }
        }
        return null;
    }

}

