
package com.taobao.config.client.processor;

import java.util.HashMap;
import java.util.Map;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;

public class ElementProcessorHub {

    private static final Logger logger = ConfigClientLogger.getLogger(ElementProcessorHub.class);

    public void processMessage(ProtocolElement input, ProtocolPackage pp) {
        ProtocolElementProcessor processor = getMessageProcessor(input);
        if (processor != null) {
            logger.debug("[Message] Processing " + input.getClass().getSimpleName());
            processor.process(input, pp);
        }
    }

    // Use a internal cache to reduce the overhead of reflection.
    private ProtocolElementProcessor getMessageProcessor(final ProtocolElement input) {
        ProtocolElementProcessor processor = messageProcessors.get(input.getClass());
        if (processor != null) {
            return processor;
        }
        final String className = getClass().getPackage().getName() + "." + input.getClass().getSimpleName() + "Processor";
        try {
            final Class<?> clazz = Class.forName(className);
            final Object instance = clazz.newInstance();
            if (instance instanceof ProtocolElementProcessor) {
                processor = (ProtocolElementProcessor) instance;
                messageProcessors.put(input.getClass(), processor);
            }
            return processor;
        } catch (Exception e) {
            logger.error("%s", "error create processor of type " + className + ", " + e.toString(), e);
            return null;
        }
    }

    private final Map<Class<?>, ProtocolElementProcessor> messageProcessors = new HashMap<Class<?>, ProtocolElementProcessor>();
}
