
package com.taobao.config.client.processor;

import com.taobao.config.client.DefaultDataClient;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.common.protocol.DataClientRegResultElement;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.PublisherRegResultElement;
import com.taobao.config.common.protocol.SubscriberRegResultElement;

public class DataClientRegResultElementProcessor extends ProtocolElementProcessor {

    void process(ProtocolElement item, ProtocolPackage pp) {
        DataClientRegResultElement element = (DataClientRegResultElement) item;
        final String dataId = element.dataId;
        final String clientId = element.clientId;
        final Error error = element.error;
        DefaultDataClient client = null;
        if (element instanceof PublisherRegResultElement) {
            client = PublisherRegistrar.find(clientId);
            if (client == null) {
                log.error("%s", "[Internal] Publisher in register result can not be found locally!" + " (Data ID: " + dataId + ", Publisher ID: " + clientId + ")");
                return;
            }
        } else if (element instanceof SubscriberRegResultElement) {
            client = SubscriberRegistrar.find(clientId);
            if (client == null) {
                log.error("%s", "[Internal] Subscriber in register result can not be found locally!" + " (Data ID: " + dataId + ", Subscriber ID: " + clientId + ")");
                return;
            }
        } else {
            log.error("%s", "[Protocol] Unknown data client register result for " + element);
            return;
        }
        client.handleRegisterResult(error == null, error);
    }
}
