
package com.taobao.config.client.metrics;

import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.services.ConfigClientService;

/**
 * 
 * @author caogu.wyp
 *
 */
public class ConfigClientMetrics {

    private static final String APPNAME = "config-client";

    public static void initMetrics() {
        //connection size
        MetricManager.register(APPNAME, new MetricName("middleware.config-client.connection.size"), new Gauge<Integer>() {

            @Override
            public Integer getValue() {
                return ConfigClientService.getClientConnections().length();
            }
        });
        //pub size
        MetricManager.register(APPNAME, new MetricName("middleware.config-client.publisher.size"), new Gauge<Integer>() {

            @Override
            public Integer getValue() {
                return PublisherRegistrar.AllPublishers().size();
            }
        });
        //sub size
        MetricManager.register(APPNAME, new MetricName("middleware.config-client.subscriber.size"), new Gauge<Integer>() {

            @Override
            public Integer getValue() {
                return SubscriberRegistrar.getSubs().size();
            }
        });
    }
}
