package com.taobao.config.client.failover;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.EventDispatcher.Event;
import com.taobao.config.client.EventDispatcher.EventListener;
import com.taobao.config.client.Events.AddSubscriberEvent;
import com.taobao.config.client.Events.RunModeChangeEvent;
import com.taobao.config.client.RunMode;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.remoting.util.LogConstants;


/**
 * ģʽеĶߺӵĶߣѯݣ֪ͨ
 * 
 * @author jiuren
 *
 */
public class FailoverModeListener extends EventListener {

    @Override
    public List<Class<? extends Event>> interest() {
        List<Class<? extends Event>> eventTypes = new ArrayList<Class<? extends Event>>();
        eventTypes.add(RunModeChangeEvent.class);
        eventTypes.add(AddSubscriberEvent.class);
        return eventTypes;
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof RunModeChangeEvent) {
            if (RunMode.isFailoverMode()) {
                onChangeToFailover();
            } else {
                onChangeToNormal();
            }
        } //
        else if (event instanceof AddSubscriberEvent) {
            onAddSubscriber((AddSubscriberEvent) event);
        }
    }
    
    /**
     * ģʽͶ߰汾š
     */
    void onChangeToFailover() {
        if (RunMode.isFailoverMode()) {
            log.warn(LogConstants.PREFIX_IMPORTANT + "[run-mode] change to [failover] mode.");

            for (Iterator<DefaultSubscriber> iter = SubscriberRegistrar.subscriberIterator(); iter
                    .hasNext();) {
                DefaultSubscriber sub = iter.next();
                sub.onServerDisconnected(); // Ͱ汾
                String dataId = sub.getDataId();
                String groupId = sub.getRegistration().getGroup();
                FailoverDataParser.copySnapshotToFailover(dataId, groupId, sub.getServerListManager().getEnv());
                CheckFailoverForUpdateTask.createAndSchedule(sub);
            }
        }
    }
    
    // ģʽעĶ
    void onAddSubscriber(AddSubscriberEvent event) {
        if (RunMode.isFailoverMode()) {
            String dataId = event.subscriber.getDataId();
            String groupId = event.subscriber.getRegistration().getGroup();
            FailoverDataParser.copySnapshotToFailover(dataId, groupId, event.subscriber.getServerListManager().getEnv());
            CheckFailoverForUpdateTask.createAndSchedule(event.subscriber);
        }
    }
    
    /**
     * ģʽ󣬽Ͷ߰汾Ųעᡣ
     */
    void onChangeToNormal() {
        if (RunMode.isNormalMode()) {
            log.warn(LogConstants.PREFIX_IMPORTANT + "[run-mode] change to [normal] mode.");

            // Ͱ汾Ųע
            for (Iterator<DefaultSubscriber> iter = SubscriberRegistrar.subscriberIterator(); iter
                    .hasNext();) {
                iter.next().onServerDisconnected();
            }
        }
    }
    
    // ===============
    static private final com.taobao.middleware.logger.Logger log = ConfigClientLogger.getLogger(FailoverModeListener.class);

}
