package com.taobao.config.client.failover;


import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import com.taobao.config.client.CachePersist;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.LocalConfigInfo;
import com.taobao.config.client.utils.IOUtils;
import com.taobao.remoting.util.LogConstants;


/**
 * ļ ࡣ
 * 
 * ļswizzle飬JAVAл
 */
class FailoverDataParser {

    /**
     * ļڵݡ
     * 
     * @return NULLʾûļл
     */
    static public List<Object> getFailoverData(String dataId, String groupId) {
        return CachePersist.parse(getFailoverFile(dataId, groupId));
    }

    /**
     * snapshotfailover. failoverұsnapshotҪ£򲻿
     */ 
    static void copySnapshotToFailover(String dataId, String groupId, String env) {
        File lastestSnapshot = CachePersist.latestSnapshot(dataId, groupId, env,false);

        if (null == lastestSnapshot) {
            log.error("%s",LogConstants.PREFIX_IMPORTANT
                    + "[copy-snapshot] snapshot not found. dataId: " + dataId + ", groupId: "
                    + groupId);
            return;
        }

        String failoverPath = MessageFormat.format(FailoverDataParser.DATA_FILE_PATTERN, dataId,
                groupId);
        File failoverFile = new File(failoverPath);

        // ļsnapshotҪ
        if (failoverFile.exists() && failoverFile.lastModified() >= lastestSnapshot.lastModified()) {
            log.info("failover is newer than snapshot, donot need override."
                    + failoverFile.getAbsolutePath());
            return;
        }

        try {
            IOUtils.copyFile(lastestSnapshot.getAbsolutePath(), failoverPath);
            log.info(LogConstants.PREFIX_IMPORTANT + "[copy-snapshot] Success to copy "
                    + lastestSnapshot.getAbsolutePath() + " to " + failoverPath);
        } catch (IOException ioe) {
            log.error("%s",LogConstants.PREFIX_IMPORTANT + "[copy-snapshot] Failed to copy "
                    + lastestSnapshot.getAbsolutePath() + " to " + failoverPath);
        }
    }
    
    
    /**
     * ݵ޸ʱ䡣NULLʾļ
     */
    static public Long getLastModified(String dataId, String groupId) {
        File dataFile = getFailoverFile(dataId, groupId);
        return dataFile.exists() ? dataFile.lastModified() : null;
    }
    
    /**
     * ļ
     */
    static public File getFailoverFile(String dataId, String groupId) {
        String dataFileStr = MessageFormat.format(DATA_FILE_PATTERN, dataId, groupId);
        File dataFile = new File(dataFileStr);
        return dataFile;
    }

    static final String DATA_FILE_PATTERN = LocalConfigInfo.FAILOVER_DATA_PATH + "/{0}/{1}.dat";
    
    static private final com.taobao.middleware.logger.Logger log = ConfigClientLogger.getLogger(FailoverDataParser.class);
}
