package com.taobao.config.client.failover;


import java.util.List;
import java.util.concurrent.TimeUnit;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.ConfigClientTimerService;
import com.taobao.config.client.DefaultSubscriber;
import com.taobao.config.client.RunMode;
import com.taobao.config.client.Subscriber;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;


/**
 * ģʽ£ڼļ£֪ͨߵģʽ£Զ˳
 * 
 * ȣÿ߶Ӧһ
 */
class CheckFailoverForUpdateTask implements Runnable {

    static public void createAndSchedule(Subscriber sub) {
        CheckFailoverForUpdateTask task = new CheckFailoverForUpdateTask(sub);
        ConfigClientTimerService.timer.scheduleWithFixedDelay(task, 0L,
                CheckFailoverForUpdateTask.INTERVAL_SECONDS, TimeUnit.SECONDS);
    }
    
    
    private CheckFailoverForUpdateTask(Subscriber subscriber) {
        this.subscriber = (DefaultSubscriber) subscriber;
    }

    public void run() {
        // ģʽ˳
        if (RunMode.isNormalMode()) {
            log.info(getClass().getName() + " exit: " + subscriber.toString());
            throw new RuntimeException("change to normal mode");
        }

        String dataId = subscriber.getDataId();
        String groupId = subscriber.getRegistration().getGroup();

        Long lastModified = FailoverDataParser.getLastModified(dataId, groupId);

        // ļ
        if (null == lastModified) {
            log.warn(LogConstants.PREFIX_IMPORTANT + "[failover-data-not-found] dataId: "
                    + dataId + ", groupId: " + groupId);
            return;
        }

        if (lastModified.longValue() != this.lastModified) {
            this.lastModified = lastModified.longValue();

            List<Object> data = FailoverDataParser.getFailoverData(dataId, groupId);
            if (null != data) {
                log.warn(LogConstants.PREFIX_IMPORTANT
                        + "[check-failover-data] set subscriber data: " + subscriber + ", " + data);
                subscriber.update(subscriber.revision().getUpdatedRevision(), data, null);
            }
        }
    }

    // ===============
    static private final Logger log = ConfigClientLogger.getLogger(CheckFailoverForUpdateTask.class);

    static public final long INTERVAL_SECONDS = 5L;

    final DefaultSubscriber subscriber;
    long lastModified = -1; // ļʱ
    
}
