
package com.taobao.config.client.exception;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;

/**
 * 
 * @author caogu.wyp
 *
 */
public class ExcEventDispatch {

    private static final Logger logger = ConfigClientLogger.getLogger(ExcEventDispatch.class);
    private static final Map<String, ExcListener> listeners = new HashMap<String, ExcListener>();
    private static final LinkedBlockingQueue<ExcEvent> events = new LinkedBlockingQueue<ExcEvent>();
    public static final AtomicBoolean isInit = new AtomicBoolean(false);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public static void init() {
        if (isInit.compareAndSet(false, true)) {
            executorService.execute(new ProcessThread());
        }
    }

    public static void addListener(String dataId, String groupId, String tenant, ExcRole er, ExcListener listener) {
        listeners.put(StringUtils.join(new Object[]{dataId, groupId, tenant, er.name()}, '#'), listener);
    }

    public static void fireEvent(ExcEvent e) {
        if (null == e) {
            throw new IllegalArgumentException("Illegal Exception Event");
        }
        events.add(e);
    }

    private static class ProcessThread implements Runnable {

        @Override
        public void run() {
            while (true) {
                try {
                    ExcEvent exception = events.take();
                    for (Entry<String, ExcListener> entry : listeners.entrySet()) {
                        switch (exception.getExcType().getExcRole()) {
                            case COMMON:
                                entry.getValue().onEvent(exception);
                                break;
                            default:
                                if (exception.getKey().equals(entry.getKey())) {
                                    entry.getValue().onEvent(exception);
                                }
                                break;
                        }
                    }
                } catch (Throwable e) {
                    logger.error("%s", "[Error ExcEvent processThread]", e);
                }
            }
        }
    }
}
