package com.taobao.config.client.bean;

import com.taobao.config.common.protocol.AttributeElement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/7/2 3:32
 */
public class ObserverData implements Serializable {

    private static final long serialVersionUID = -964582210783624641L;
    Object data;
    private String appName;//appName Ϊ
    private String machineGroup;//appName Ϊ
    private String site;
    private String unit;
    private String ipGroup;//ipGroup Ϊ

    public ObserverData(Object data){
        this.data = data;
    }

    public void setBaseData(Map<String, String> baseDataMap) {

        unit = baseDataMap.get(AttributeElement.ATTRIBUTE_UNIT);
        appName = baseDataMap.get(AttributeElement.ATTRIBUTE_APP);
        ipGroup = baseDataMap.get(AttributeElement.ATTRIBUTE_IPGROUP);
        machineGroup = baseDataMap.get(AttributeElement.ATTRIBUTE_MACHINEGROUP);
        site = baseDataMap.get(AttributeElement.ATTRIBUTE_SITE);
    }

    public String getAppName() {
        return appName;
    }

    public String getMachineGroup() {
        return machineGroup;
    }

    public String getSite() {
        return site;
    }

    public String getUnit() {
        return unit;
    }

    public String getIpGroup() {
        return ipGroup;
    }

    public Object getData() {
        return data;
    }

    @Override
    public String toString() {
        return "["+data.toString()+","+appName+","+machineGroup+","+unit+","+site+","+ipGroup+"]";
    }
}
