package com.taobao.config.client.bean;

import com.taobao.config.client.ConfigClientLogger;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/7/17 4:28
 */
public class InstanceMetaData {
    private static final Logger logger = ConfigClientLogger.getLogger(InstanceMetaData.class);
    private final String appName;//appName Ϊ
    private final String machineGroup;//appName Ϊ
    private final String site;
    private final String unit;
    private final String ipGroup;
    private final String accessKey;
    private final String secretKey;


    public InstanceMetaData(String appName, String machineGroup, String site, String unit,
                            String ipGroup, String accessKey, String secretKey){

        this.appName = appName;
        this.machineGroup = machineGroup;
        this.site = site;
        this.unit = unit;
        this.ipGroup = ipGroup;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public InstanceMetaData(String appName, String machineGroup, String site, String unit,
                            String ipGroup){

        this.appName = appName;
        this.machineGroup = machineGroup;
        this.site = site;
        this.unit = unit;
        this.ipGroup = ipGroup;
        this.accessKey = null;
        this.secretKey = null;
    }

    public InstanceMetaData(String ipGroup){

        this.appName = null;
        this.machineGroup = null;
        this.site = null;
        this.unit = null;
        this.ipGroup = ipGroup;
        this.accessKey = null;
        this.secretKey = null;
    }
    public InstanceMetaData(String appName, String accessKey, String secretKey){

        this.appName = appName;
        this.machineGroup = null;
        this.site = null;
        this.unit = null;
        this.ipGroup = null;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }
    public InstanceMetaData(String appName, String machineGroup, String site, String unit){
//        if(StringUtils.isExistBlank(appName,machineGroup,site,unit)){
//            logger.debug("InstanceMetaData init value is blank");
//        }
        this.appName = appName;
        this.machineGroup = machineGroup;
        this.site = site;
        this.unit = unit;
        this.ipGroup = null;
        this.accessKey = null;
        this.secretKey = null;
    }
    public String getAppName() {
        return appName;
    }

    public String getMachineGroup() {
        return machineGroup;
    }

    public String getSite() {
        return site;
    }

    public String getUnit() {
        return unit;
    }

    public String getIpGroup() {
        return ipGroup;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    @Override
    public boolean equals(Object o) {
        return this.hashCode()==o.hashCode();
    }

    @Override
    public String toString() {
        return "InstanceMetaData[" +(appName != null ? appName : "null")
                + "," + (machineGroup != null ? machineGroup : "null")
                + "," + (unit != null ? unit : "null")
                + "," + (site != null ? site : "null")
                + "," + (ipGroup != null ? ipGroup : "null") + "]"
                + "," + (accessKey != null ? accessKey : "null") + "]"
                + "," + (secretKey != null ? secretKey : "null") + "]";
    }

    public String getConnectKey(){
        return (ipGroup != null) ? ("InstanceMetaData["+ipGroup+"]") : null;
    }

    @Override
    public int hashCode() {
        return (appName != null ? appName.hashCode() : 0)
                + (machineGroup != null ? machineGroup.hashCode() : 0)
                + (site != null ? site.hashCode() : 0)
                + (unit != null ? unit.hashCode() : 0)
                + (ipGroup != null ? ipGroup.hashCode() : 0)
                + (accessKey != null ? accessKey.hashCode() : 0)
                + (secretKey != null ? secretKey.hashCode() : 0);
    }


}
