package com.taobao.config.client;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;


/**
 * 
 *
 * <p>ͨSubscriber.getSubscription()һµġġ
 *
 * <p>FutureĶݻȡӿڣ֧ͬ첽ַʽһSubscription󣬿Զε {@link #waitNext()}
 *  {@link #waitNext(long)} ȡݸ¡
 * <p>ÿݶֻһ߳ʹãҪڶ̵߳ĳʹöģ봴ݶġ
 * <p><b>ע⣺ÿδSubscriptionӵб˴˶֪ͨ״̬ԲҪڵȴѭзSubscription
 * ȷѭⴴһSubscriptionѭڶε {@link #waitNext()}  {@link #waitNext(long)} </b>
 *
 * @author wufeng
 * @since 1.2
 */
public interface Subscription {

	/**
	 * 鵱ǰǷδȡĶݡ
	 *
	 * @return trueһε {@link #waitNext()}  {@link #waitNext(long)} õĵݶ
	 * ֱöĵݣʱ
	 */
    boolean hasNext();

    /**
     * ȴֱһε {@link #waitNext()}  {@link #waitNext(long)} 󷢲ݡͬʽ
     *
     * <p>ʱδȡݣֱӷ֮򽫵ȴֱöĵݡ
     *
     * @throws CancellationException ȡ˶ݵĶġ
     * @throws InterruptedException ȴ̱߳жϡ
     *
     * @return ĵ
     */
    List<Object> waitNext() throws CancellationException, InterruptedException;

    /**
     * ȴһʱ䣬ֱһε {@link #waitNext()}  {@link #waitNext(long)} 󷢲ݡͬʽ
     *
     * <p>ʱδȡݣֱӷ֮򽫵ȴָĳʱʱֱöĵݡ
     *
     * @param timeoutInMillis ʱʱλ룩
     *
     * @throws CancellationException ȡ˶ݵĶġ
     * @throws InterruptedException ȴ̱߳жϡ
     *
     * @return ȴʱδõݣ򷵻null򷵻ضĵݡ
     */
    List<Object> waitNext(long timeoutInMillis) throws CancellationException, InterruptedException;
}


/**
 * @author JIUREN
 *
 */
class DefaultSubscription implements Subscription, SubscriberDataObserver {

    @Override
    public void handleData(String dataId, List<Object> data) {
        updatedData.clear();
        updatedData.offer(data);
    }
    
    @Override
    public boolean hasNext() {
        return updatedData.size() > 0;
    }
    
    @Override
    public List<Object> waitNext() throws CancellationException, InterruptedException {
        return updatedData.take();
    }
    
    @Override
    public List<Object> waitNext(long timeoutInMillis) throws CancellationException,
            InterruptedException {
        return updatedData.poll(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    int updateDataSize() {
        return updatedData.size();
    }
    
    private final BlockingQueue<List<Object>> updatedData = new ArrayBlockingQueue<List<Object>>(1);

}

