package com.taobao.config.client;

import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.protocol.AttributeElement;

import java.util.Collection;
import java.util.Collections;
import java.util.List;


/**
 * ߵǼǱ
 *
 * ÿһߣҪʹΨһĶߵǼǱעᡣÿһݵǼǱֻעһΣظעὫжΪЧעʱnull
 * ʹòͬĵǼǱעᣬʹеǼǵϢȫͬҲͬĶߡ
 *
 * @author wufeng
 * @since 1.2
 */
public class SubscriberRegistration extends DataClientRegistration {

    /**
     * дһµĶߵǼǱ
     *
     * @param subscriberName ߵƣڹʶߡʹϿѡĺ׺ֲͬʵ
     * <p>һݱʶֻڼȨͳơԱάȹУԹûӰ죬ҪΨһԡΪ˹ķ㣬뾡ܵıΨһԡ
     * @param dataId 趩ݵΨһʶͨ˱ʶȡͬʶķݡ
     */
    public SubscriberRegistration(String subscriberName, String dataId) {
        super(subscriberName, dataId, null);
        setAttribute(AttributeElement.ATTRIBUTE_REGISTRANT_TRACK, new Throwable());
    }

    public SubscriberRegistration(String subscriberName, String dataId, String datumId) {
        super(subscriberName, dataId, datumId);
        setAttribute(AttributeElement.ATTRIBUTE_REGISTRANT_TRACK, new Throwable());
    }

    /**
     * ô˶ߵǷñػơ
     *
     * <p>ػƽֱЧ
     * <ul>
     * <li>ڻ÷ǰȼشǰݣã߻յݡ</li>
     * <li>ݸºͬУ߻ʹá</li>
     * </ul>
     *
     * <p>رձػƵЧ
     * <ul>
     * <li>߻õݣһյݣһǴӷ˵õģͨΪµݡ</li>
     * <li>޷ӷ˻ʱ쳣ͨ쳣߽յκݡ</li>
     * </ul>
     *
     * θģ
     *   ǿƻã־ݣֹCSڵӦ޷
     *
     * @param cacheable ǷñػƣĬΪá
     *
     * @since 1.3
     */
    public void setCacheable(boolean cacheable) {}

    public boolean isCacheable() {
        return true;
    }


    /**
     * Ķ
     * öŷָ"envG1,envG2,envG3"
     * @param ipGroupList ͬΧ envGroups Ϊ
     */
    public void setSubIpGroupList(final List<String> ipGroupList){
        if(ipGroupList != null){
            StringBuilder ipGroupStrbuilder=new StringBuilder();

            for(int i=0;i<ipGroupList.size();i++) {
                String ipGroup = ipGroupList.get(i);
                if(StringUtils.isNotBlank(ipGroup)){
                    ipGroupStrbuilder.append(ipGroup);
                    if(i != (ipGroupList.size() - 1)){
                        ipGroupStrbuilder.append(",");
                    }
                }
            }
            String ipGroupStr = ipGroupStrbuilder.toString();
            if(StringUtils.isNotBlank(ipGroupStr)){
                setAttribute(AttributeElement.ATTRIBUTE_SUB_IPGROUPS, ipGroupStr);
            }
        }
    }

    public String getSubIpGroups(){
        return getAttribute(AttributeElement.ATTRIBUTE_SUB_IPGROUPS);
    }

    /**
     * ȡǼǱеĶ
     *
     * @return ǼǱдĶ
     */
    public String getSubscriberName() {
        return getClientName();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("Subscriber \"" + getClientId() + "\" ");
        buffer.append("[Data ID: " + getDataId() + "]");
        String group = getGroup();
        if (group != null)
            buffer.append("[Group: " + group + "]");
        if (isCacheable())
            buffer.append("[Cacheable]");
        buffer.append("[Tenant: " + this.getTenant() + "]");
        buffer.append("[subIpGroups: " + this.getSubIpGroups() + "]");
        return buffer.toString();
    }
}
