
package com.taobao.config.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import com.taobao.config.client.Events.AddSubscriberEvent;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;

/**
 * ĶȨĶ߱
 *
 * ĵμ{@link PublisherRegistrar}
 *
 * @author wufeng
 * @since 1.2
 */
public class SubscriberRegistrar {

    /**
     * һµĶģԻȡݡ
     *
     * @param registration ߵǼǱ
     * @return ͨĶƾ֤nullʾʧܣǷʹͬһݵǼǱ˶Σ
     * ֹdataIdgroupIdtenantservercenter ΨclientΨһԣ
     */
    public static synchronized Subscriber register(SubscriberRegistration registration) {
        if (null == registration) {
            throw new IllegalArgumentException("registration is null");
        }
        String clientId = registration.getClientId();
        // ظģһ
        DefaultSubscriber subscriber = findExitSub(registration);
        if (null != subscriber) {
            log.info(LogConstants.PREFIX_IMPORTANT + "[reuse-subscriber] " + subscriber);
            return subscriber;
        }
        try {
            subscriber = new DefaultSubscriber(registration);
            clients.put(clientId, subscriber);
            EventDispatcher.fireEvent(new AddSubscriberEvent(subscriber));
        } catch (Exception e) {
            log.error("%s", "[Internal] Exception in registering subscriber: ", e);
        }
        return subscriber;
    }

    public static boolean unregister(Subscriber subscriber) {
        if (null == subscriber) {
            throw new IllegalArgumentException("subscriber is null");
        }
        log.info("[Registrar] Unregister " + subscriber.getRegistration());
        try {
            ((DefaultSubscriber) subscriber).unregister();
            clients.remove(subscriber.getClientId());
            return true;
        } catch (Exception e) {
            log.error("%s", "[Internal] Exception in unregistering subscriber: ", e);
            return false;
        }
    }

    // ߵ
    static public Iterator<DefaultSubscriber> subscriberIterator() {
        return clients.values().iterator();
    }

    private static DefaultSubscriber findExitSub(SubscriberRegistration registration) {
        String dataId = registration.getDataId();
        String groupId = registration.getGroup();
        String tenant = registration.getTenant();
        String serverEnv = registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER);
        String centerEnv = registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER);
        List<DefaultSubscriber> existSubs = findSubs(dataId, groupId, tenant);
        for (DefaultSubscriber subscriber : existSubs) {
            String subCenterEnv = subscriber.getRegistration().getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER);
            String subServerEnv = subscriber.getRegistration().getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER);
            // null
            if (null == serverEnv && centerEnv == null && null == subCenterEnv && null == subServerEnv) {
                return subscriber;
            }
            //centerEnv 
            if (null != centerEnv && centerEnv.equals(subCenterEnv)) {
                return subscriber;
            }
            //serverEnv 
            if (null != serverEnv && serverEnv.equals(subServerEnv)) {
                return subscriber;
            }
        }
        return null;
    }

    private static List<DefaultSubscriber> findSubs(String dataId, String groupId, String tenant) {
        List<DefaultSubscriber> result = new LinkedList<DefaultSubscriber>();
        for (DefaultSubscriber subscriber : clients.values()) {
            if (dataId.equals(subscriber.getDataId()) && //
                    groupId.equals(subscriber.getRegistration().getGroup()) && //
                    tenant.equals(subscriber.getRegistration().getTenant()))
                result.add(subscriber);
        }
        return result;
    }

    public static DefaultSubscriber find(String clientId) {
        return clients.get(clientId);
    }

    public static List<DefaultSubscriber> findByDataId(String dataId) {
        List<DefaultSubscriber> result = new LinkedList<DefaultSubscriber>();
        for (DefaultSubscriber subscriber : clients.values()) {
            if (subscriber.getDataId().equals(dataId))
                result.add(subscriber);
        }
        return result;
    }

    public static List<String> findClientIdsByDataId(String dataId) {
        List<String> result = new ArrayList<String>();
        for (Map.Entry<String, DefaultSubscriber> entry : clients.entrySet()) {
            Subscriber subscriber = entry.getValue();
            if (subscriber.getDataId().equals(dataId))
                result.add(entry.getKey());
        }
        return result;
    }

    /**
     * For internal use only. To disable a publisher, please use
     * {@link #unregister(Subscriber subscriber)}.
     */
    static boolean remove(Subscriber subscriber) {
        return clients.remove(subscriber.getClientId()) != null;
    }

    static public List<Subscriber> getSubs() {
        List<Subscriber> subs = new ArrayList<Subscriber>(clients.size());
        subs.addAll(clients.values());
        return subs;
    }

    public static Collection<DefaultSubscriber> AllDefaultSubs() {
        return Collections.unmodifiableCollection(clients.values());
    }

    // ================
    static final Logger log = ConfigClientLogger.getLogger(SubscriberRegistrar.class);
    static final ConcurrentHashMap<String /*clientId*/, DefaultSubscriber> clients = new ConcurrentHashMap<String, DefaultSubscriber>();
    static {
        new Initialization();
    }
}
