
package com.taobao.config.client;

import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


public class ServerListManagerFactory {

    private static final Logger logger = ConfigClientLogger.getLogger(ServerListManagerFactory.class);
    /** -ӳصkey-value */
    private static final ConcurrentHashMap<String, List<ServerListManager>> serverListManagerPool = new ConcurrentHashMap<String, List<ServerListManager>>();
//    private static final ServerListManager defaultMgr = new ServerListManager(null);
    private static String defaultMrgKey = "defaultMrgKey";
//
//    static {
//        List<ServerListManager> serverListManagers = new ArrayList<ServerListManager>(1);
//        serverListManagers.add(defaultMgr);
//        serverListManagerPool.put(defaultMrgKey, serverListManagers);
//    }
//    public static ServerListManager getFirstDefaultServerListManager(){
//        return defaultMgr;
//    }

    public static ServerListManager getDefaultServerListManager(String conType,InstanceMetaData instanceMetaData) {
        String instanceKey = null;
        if(instanceMetaData != null){
            instanceKey = instanceMetaData.getConnectKey();
        }
        return getAvailableManager(null, defaultMrgKey, conType, instanceKey);
    }

    /**
     * Ӳcenterserverʱлȡ
     * @param attr
     * @param value
     * @return
     */
    public static synchronized ServerListManager getServerListManager(String attr, String value, String conType, InstanceMetaData instanceMetaData) {
        if (!LocalAttribute.ATTRIBUTE_CENTER.equals(attr) && !LocalAttribute.ATTRIBUTE_SERVER.equals(attr)) {
                // TODO attr ôʱ
                String message = "[Global] Set LocalAttribute: " + attr + " ,Error ,Check your code";
                logger.error("%s", message);
                throw new IllegalArgumentException(message);
        }
        String instanceKey = null;
        if(instanceMetaData !=null){
            instanceKey = instanceMetaData.getConnectKey();
        }
        return getAvailableManager(attr, value, conType, instanceKey);
    }

    /**
     * ȡ ˶ӹ Ҫͬʱ㣨pubsub򷵻أͷһµģ
     * @param key ӵkey
     * @return
     */
    private static synchronized ServerListManager getAvailableManager(String attr, String key, String conType, String instanceKey){
        key = key.trim();
        String poolKey = key;
        if(StringUtils.isNotBlank(instanceKey)){
            instanceKey = instanceKey.trim();
            poolKey=key+"-"+instanceKey;
        }
        ServerListManager mgr = null;
        /** ȥе*/
        List<ServerListManager> serverListManagers = getServerListManagerList(poolKey);
        for (Iterator<ServerListManager> iterator = serverListManagers.iterator(); iterator.hasNext();) {
            ServerListManager serverListManager = iterator.next();
            /** ߼Ƿ ųѾ˵*/
            if(ConfigClientPerfCtrl.isMultiConnections()) {
                if(conType == null){
                    if (serverListManager.pubCountOverflow() || serverListManager.subCountOverflow()) {
                        continue;
                    }
                }
                if(LocalConfigInfo.SERVER_CON_PUB_TYPE.equals(conType)){
                    if (serverListManager.pubCountOverflow()) {
                        continue;
                    }
                }
                if(LocalConfigInfo.SERVER_CON_SUB_TYPE.equals(conType)){
                    if (serverListManager.subCountOverflow()) {
                        continue;
                    }
                }
            }
            mgr = serverListManager;
            break;
        }
        /** ûпõ ʹ*/
        if(mgr == null) {
            if(attr == null) {
                mgr = createServerManager(instanceKey);
            } else if (LocalAttribute.ATTRIBUTE_CENTER.equals(attr)) {
                mgr = createServerManager(key,instanceKey);
            } else if(LocalAttribute.ATTRIBUTE_SERVER.equals(attr)) {
                mgr = createServerManager(key.split(";"),instanceKey);
            } else {
                mgr = createServerManager(instanceKey);
            }
            serverListManagers.add(mgr);
        }
        return mgr;
    }

    /** ȡΪnullnew һϷ*/
    private static synchronized List<ServerListManager> getServerListManagerList(String key) {
        List<ServerListManager> serverListManagers = serverListManagerPool.get(key);
        if (serverListManagers == null) {
            serverListManagers = new ArrayList<ServerListManager>(0);
            serverListManagerPool.put(key, serverListManagers);
        }
        return serverListManagers;
    }
    /**
     *
     * @param instanceMetaStr Ϊnull
     * @return
     */
    private static ServerListManager createServerManager(String center, String instanceMetaStr) {
        ServerListManager s = new ServerListManager(center, instanceMetaStr);
        s.start();
        return s;
    }

    /**
     *
     * @param instanceMetaStr Ϊnull
     * @return
     */
    private static ServerListManager createServerManager(String instanceMetaStr) {
        ServerListManager s = new ServerListManager(instanceMetaStr);
        s.start();
        return s;
    }
    /**
     *
     * @param instanceMetaStr Ϊnull
     * @return
     */
    private static ServerListManager createServerManager(String[] serverUrls,String instanceMetaStr) {
        List<String> fixed = new ArrayList<String>(serverUrls.length);
        for (String url : serverUrls) {
            fixed.add(url);
        }
        ServerListManager s = new ServerListManager(fixed,instanceMetaStr);
        s.start();
        return s;
    }


    public static List<String> dumpConnectionStatus() {
        try {
            List<String> mgrConnectionStatus = new ArrayList<String>();
            for (Map.Entry<String, List<ServerListManager>> entry : serverListManagerPool.entrySet()) {
                List<ServerListManager> serverListManagers = new ArrayList<ServerListManager>(entry.getValue());
                for (Iterator<ServerListManager> iterator = serverListManagers.iterator(); iterator.hasNext();) {
                    ServerListManager serverListManager = (ServerListManager) iterator.next();
                    mgrConnectionStatus.add(serverListManager.getConnectionsStatus());
                }
            }
            return mgrConnectionStatus;
        } catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static String dumpDetail() {
        try {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, List<ServerListManager>> entry : serverListManagerPool.entrySet()) {
                List<ServerListManager> serverListManagers = new ArrayList<ServerListManager>(entry.getValue());
                for (Iterator<ServerListManager> iterator = serverListManagers.iterator(); iterator.hasNext();) {
                    ServerListManager serverListManager = (ServerListManager) iterator.next();
                    sb.append("\n" + serverListManager);
                }
            }
            return "[server-list-mgr-new]" + sb.toString();
        } catch (Exception e) {
            return "";
        }
    }

    private static List<String> parseServerListStr(String value) {
        String[] urlList = value.split(";");
        List<String> fixed = new ArrayList<String>(urlList.length);
        for (String url : urlList) {
            fixed.add(url);
        }
        return fixed;
    }
}
