
package com.taobao.config.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import com.taobao.config.client.exception.ConfigClientException;
import com.taobao.config.client.http.HttpResult;
import com.taobao.config.client.utils.HttpUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.ConfigServerURL;
import com.taobao.config.common.InternalDataID;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Connection;

public class ServerListManager {

    // ==========================
    static final Logger log = ConfigClientLogger.getLogger(ServerListManager.class);
    /** */
    final boolean isFixed;
    volatile String center = null;
    volatile boolean isStarted = false;
    volatile List<String> serverUrls = new ArrayList<String>();
    /** Ӵ */
    final ConnectionProxy connectionProxy;
    //mgrѾעpublisherʵ
    AtomicLong pubCount = new AtomicLong();
    AtomicLong subCount = new AtomicLong();
    private String env = LocalConfigInfo.DEFAULT_ENV;
    private String instanceMetaStr = null;
    /** workerģ*/
    private static final ExecutorService workerPool = Executors.newCachedThreadPool(new ThreadFactory() {

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("ConfigClientWorker-Thread");
            return t;
        }
    });
    private ConfigClientWorker configClientWork = new ConfigClientWorker(this);

    public ConfigClientWorker getConfigClientWork() {
        return configClientWork;
    }
    /** ʼҪ*/
    private void executeConfigClientWork() {
        workerPool.execute(configClientWork);
    }

    /**
     *
     * @param instanceMetaStr Ϊnull
     */
    public ServerListManager(String instanceMetaStr) {
        executeConfigClientWork();
        isFixed = false;
        isStarted = false;
        env = LocalConfigInfo.DEFAULT_ENV;
        this.instanceMetaStr = instanceMetaStr;
        if(StringUtils.isNotBlank(this.instanceMetaStr)){
            env=env+"-"+this.instanceMetaStr;
        }
        connectionProxy = new ConnectionProxy(this);
    }

    /**
     *
     * @param instanceMetaStr Ϊnull
     */
    public ServerListManager(String center, String instanceMetaStr) {
        executeConfigClientWork();
        this.center = center;
        isFixed = false;
        isStarted = false;
        env = center;
        this.instanceMetaStr = instanceMetaStr;
        if(StringUtils.isNotBlank(this.instanceMetaStr)){
            env=env+"-"+this.instanceMetaStr;
        }
        connectionProxy = new ConnectionProxy(this);
    }

    /**
     *
     * @param instanceMetaStr Ϊnull
     */
    public ServerListManager(List<String> fixed, String instanceMetaStr) {
        executeConfigClientWork();
        isFixed = true;
        isStarted = true;
        env = fixed.toString();
        this.instanceMetaStr = instanceMetaStr;
        if(StringUtils.isNotBlank(this.instanceMetaStr)){
            env=env+"-"+this.instanceMetaStr;
        }
        serverUrls = new ArrayList<String>(fixed);
        connectionProxy = new ConnectionProxy(this);
    }

    public void start() {
        if (isStarted || isFixed) {
            return;
        }
        for (int i = 0; i < 3 && serverUrls.isEmpty(); ++i) {
            new GetServerListTask().run();
        }
        if (serverUrls.isEmpty()) {
            if(!Boolean.getBoolean("CS.NOSERVER.NOEXIT")){
                log.error("%s", "########## cannot get serverlist, so exit jvm env=" + env);
                new ConfigClientException("Env-error","cannot get serverlist, so exit jvm env=" + env).printStackTrace();
                System.exit(0);
            } else {
                log.error("%s", "########## cannot get serverlist, should exit jvm, but jvm args CS.NOSERVER.NOEXIT=true env=" + env);
            }
        }

        ConfigClientTimerService.timer.scheduleWithFixedDelay(new GetServerListTask(), 0L, 30L, TimeUnit.SECONDS);
        isStarted = true;
    }

    // صײTCP
    Connection getConnection() {
        return null == connectionProxy.client ? null : connectionProxy.client.getConnection();
    }

    class GetServerListTask implements Runnable {

        @Override
        public void run() {
            try {
                updateIfChanged(getApacheServerList());
            } catch (Exception e) {
                log.error("%s", "[serverlist] failed to get serverlist, " + e.toString(), e);
            }
        }
    }

    List<String> getServerUrls() {
        return new ArrayList<String>(serverUrls);
    }

    public Iterator<ConfigServerURL> iterator() {
        if (serverUrls.isEmpty()) {
            log.error("%s", "[serverlist] No server address defined!");
        }
        return new ServerAddressIterator(serverUrls);
    }

    private void updateIfChanged(List<String> newList) {
        if (newList.isEmpty()) { // ΪAPACHEӰclient
            log.warn("[serverlist] get empty serverlist from apache.");
            return;
        }
        //жϴСǷһ
        if (serverUrls.equals(newList)) {
            return;
        }
        serverUrls = new ArrayList<String>(newList);
        CachePersist.save(InternalDataID.SERVER_LIST, null, serverUrls, env);
        //TODO ҪеӶֻҪserverListManagerļ
        //Ⱥַб,ǰȻб,ر
        //Ⱥַһ,ͻȫһȫ
        Connection connection = getConnection();
        if (connection != null) {
            if (!serverUrls.contains(connection.getRemoteAddress())) {
                this.connectionProxy.close();
                log.warn("[close-connection] when serverlist updated." + connection);
            }
        }
        this.configClientWork.closeConnection();
        log.warn("[serverlist] updated to " + serverUrls + "domain=" + ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort());
    }

    public List<String> queryServerlist() {
        return this.getApacheServerList();
    }

    public static String addressServerUrl(String center) {
        String domain = ConfigClientSetting.getAddressServerDomain() + ":" + ConfigClientSetting.getAddressServerPort();
        String url = "http://" + domain + "/configserver/serverlist";
        if (center != null && (!center.equals("default")) && (!center.equals(LocalConfigInfo.DEFAULT_ENV))) {
            url = url + "-" + center + "?nofix=1";
        }
        return url;
    }

    public static List<String> getServerListByAs(String center) {
        String url = addressServerUrl(center);
        try {
            HttpResult httpResult = HttpUtils.invokeURL(url);
            if (200 == httpResult.code) {
                return HttpUtils.httpResultLines(httpResult);
            } else if (404 == httpResult.code) {
                log.error("%s", "[serverlist] failed to get serverlist from " + url + ", error code " + httpResult.code + " Cause by IllegalCenter set as  " + center);
                return Collections.emptyList();
            } else {
                log.error("%s", "[serverlist] failed to get serverlist from " + url + ", error code " + httpResult.code);
                return Collections.emptyList();
            }
        } catch (IOException e) {
            log.warn("[serverlist] exception, " + url + ", " + e.toString(), e);
            return Collections.emptyList();
        }
    }

    /**
     * 
     * @return not null
     */
    List<String> getApacheServerList() {
        return getServerListByAs(this.center);
    }



    public void incrementPubCount() {
        pubCount.incrementAndGet();
    }

    public void decrementPubCount() {
        pubCount.decrementAndGet();
    }

    public boolean pubCountOverflow() {
        return pubCount.get() >= ConfigClientPerfCtrl.maxPubCountPerConn;
    }

    public boolean subCountOverflow() {
        return subCount.get() >= ConfigClientPerfCtrl.maxSubCountPerConn;
    }

    public void incrementSubCount() {
        subCount.incrementAndGet();
    }

    public void decrementSubCount() {
        subCount.decrementAndGet();
    }

    public String getConnectionsStatus() {
        return env + "|" + connectionProxy.getReConnected();
    }

    public String getCenter(){
        return center;
    }

    public String getEnv(){
        return env;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("env=" + env);
            stringBuffer.append(",serverUrls=" + serverUrls.toString());
            stringBuffer.append(",pubCount=" + pubCount.get());
            stringBuffer.append(",subCount=" + subCount.get());
            stringBuffer.append(",reConnected=" + connectionProxy.getReConnected());
            Connection connection = getConnection();
            if (connection != null) {
                stringBuffer.append(",connection=" + connection);
            }
        } catch (Exception e) {
        }
        return stringBuffer.toString();
    }
}





class ServerAddressIterator implements Iterator<ConfigServerURL> {
    static final Logger log = ConfigClientLogger.getLogger(ServerListManager.class);
    final List<ConfigServerURL> sorted;
    final Iterator<ConfigServerURL> iter;
    public ServerAddressIterator(List<String> source) {
        sorted = new ArrayList<ConfigServerURL>();
        for (String address : source) {
            try {
                sorted.add(new ConfigServerURL(address));
            } catch (Exception e) {
                log.error("%s", "serverAddressIP:"+address+" error on new ConfigServerURL, ignore this ip", e);
            }
        }
        Collections.shuffle(sorted);
        iter = sorted.iterator();
    }

    public boolean hasNext() {
        return iter.hasNext();
    }

    public ConfigServerURL next() {
        return iter.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

}
