package com.taobao.config.client;

import java.io.File;
import java.util.concurrent.TimeUnit;
import com.taobao.config.client.failover.FailoverModeListener;
import com.taobao.middleware.logger.Logger;


public class RunMode {

    static public boolean isNormalMode() {
        return NORMAL == runMode;
    }

    static public boolean isFailoverMode() {
        return FAILOVER == runMode;
    }

    static void checkRunMode() {
        boolean isFailOver = new File(LocalConfigInfo.FAILOVER_TRIGGER_PATH).exists();
        if (RunMode.isFailoverMode() != isFailOver) {
            // change mode
            RunMode.runMode = isFailOver ? RunMode.FAILOVER : RunMode.NORMAL;

            // fire run mode change event
            EventDispatcher.fireEvent(new Events.RunModeChangeEvent());
        }
    }

    // ===================
    private static final Logger log = ConfigClientLogger.getLogger(RunMode.class);
    static public final int NORMAL = 1;
    static public final int FAILOVER = 2;

    static private volatile int runMode = NORMAL;

    static {
        new FailoverModeListener();

        // check run mode periodically
        ConfigClientTimerService.timer.scheduleWithFixedDelay(new Runnable() {
            public void run() {
                try {
                    checkRunMode();
                } catch (Throwable ex) {
                    log.error("%s","error when check run mode: " + ex.toString(), ex);
                }
            }
        }, 0, 5, TimeUnit.SECONDS);
    }
}
