
package com.taobao.config.client;

import java.io.Serializable;
import java.security.InvalidParameterException;
import com.taobao.config.common.protocol.AttributeElement;

/**
 * ߵǼǱ
 *
 * ÿһߣҪʹΨһķߵǼǱעᡣǼǱһԵģÿһݵǼǱֻעһΣظעὫЧעʱnull
 * ʹòͬĵǼǱעᣬʹеǼǵϢȫͬҲͬķߡ
 *
 * @param T ϣͣǿлࡣȻͬһDataIDķ߿Էͬ͵ݣ鱣һ¡
 *
 * @author wufeng
 * @since 1.2
 */
public class PublisherRegistration<T extends Serializable> extends DataClientRegistration {

    /**
     * дһµķߵǼǱָʶDatumID
     *
     * <p>עʱָDatumIDķֻԼǰݡ
     *
     * <p>ָDatumIDķ߲ܷ־ݡ
     * @see PublisherRegistration#setPersistency(boolean)
     *
     * @param publisherName ߵƣڹʶ𷢲ߡʹϿѡĺ׺ֲͬʵ
     * <p>һݱʶֻڼȨͳơԱάȹУԹûӰ죬ҪΨһԡΪ˹ķ㣬뾡ܵıΨһԡ
     * @param dataId ݵΨһʶ߱ʹͬıʶӦݡʹpackageʽ
     */
    public PublisherRegistration(String publisherName, String dataId) {
        this(publisherName, dataId, null);
    }

    /**
     * дһµķߵǼǱָʶDatumID
     *
     * <p>עʱָDatumIDķݽͬDataIDDatumIDķߴǰݡ
     *
     * <p>ָֻDatumIDķ߲ܷ־ݡ
     * @see PublisherRegistration#setPersistency(boolean)
     *
     * @param publisherName ߵƣڹʶ𷢲ߡʹϿѡĺ׺ֲͬʵ
     * <p>һݱʶֻڼȨͳơԱάȹУԹûӰ죬ҪΨһԡΪ˹ķ㣬뾡ܵıΨһԡ
     * @param dataId ݵΨһʶ߱ʹͬıʶӦݡʹpackageʽ
     * @param datumId ݼоΨһʶ߿ָͨ˱ʶȡͬһDataIDвͬĴ˱ʶķ
     *                ڿͻԶԣsdkͨԲѯ
     */
    public PublisherRegistration(String publisherName, String dataId, String datumId) {
        super(publisherName, dataId, datumId);
    }

    /**
     * ȡǼǱеķ
     *
     * @return ǼǱдķ
     */
    public String getPublisherName() {
        return getClientName();
    }

    /**
     * ôݵĳ־ûԡ
     *
     * <p>־ûڷߺ󽫱ЧֱͬDataIDDatumIDķ߷µݺű
     *
     * @param state ǷҪ־û
     */
    public void setPersistency(boolean state) {
        if (state == true && getDatumId() == null) {
            throw new InvalidParameterException("Publisher without specified datum ID is not persistable.");
        }
        setAttribute(AttributeElement.ATTRIBUTE_PERSISTENCY, state);
    }

    /**
     * ȡݵĳ־ûԡ
     *
     * @see PublisherRegistration#setPersistency()
     */
    public boolean getPersistency() {
        Boolean state = (Boolean) getAttribute(AttributeElement.ATTRIBUTE_PERSISTENCY);
        if (state == null) {
            return false;
        } else {
            return state.booleanValue();
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("Publisher \"" + getClientId() + "\" ");
        buffer.append("[Data ID: " + getDataId() + "]");
        String group = getGroup();
        if (group != null)
            buffer.append("[Group: " + group + "]");
        if (getPersistency())
            buffer.append("[Persistent]");
        buffer.append("[Tenant: " + this.getTenant() + "]");
        return buffer.toString();
    }
}
