
package com.taobao.config.client;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;

public class PublisherRegistrar {

    private static final Logger log = ConfigClientLogger.getLogger(PublisherRegistrar.class);
    protected static final Map<String /*clientId*/, DefaultPublisher<?>> clients = new ConcurrentHashMap<String, DefaultPublisher<?>>();

    /**
     * עһµķԷ
     *
     * @param registration ߵǼǱ
     * @return עͨķƾ֤nullʾעʧܣǷʹͬһݵǼǱע˶Σ
     */
    @SuppressWarnings("unchecked")
    public static synchronized <T extends Serializable> Publisher<T> register(PublisherRegistration<T> registration) {
        if (null == registration) {
            throw new IllegalArgumentException("registration is null");
        }
        String dataId = registration.getDataId();
        if (dataId.length() > ConfigClientPerfCtrl.dataIdLengthMax) {
            throw new IllegalArgumentException("dataId length bigger than " + ConfigClientPerfCtrl.dataIdLengthMax + " :" + dataId);
        }
        String groupId = registration.getGroup();
        if (groupId.length() > ConfigClientPerfCtrl.groupLengthMax) {
            throw new IllegalArgumentException("group length bigger than " + ConfigClientPerfCtrl.groupLengthMax + " :" + groupId);
        }
        String clientId = registration.getClientId();
        if (clientId.length() > ConfigClientPerfCtrl.publisherNameLengthMax) {
            throw new IllegalArgumentException("publisherName length bigger than " + ConfigClientPerfCtrl.publisherNameLengthMax + " :" + clientId);
        }
        if (clients.size() >= ConfigClientPerfCtrl.pubCountMax) {
            throw new IllegalArgumentException("publisher count bigger than " + ConfigClientPerfCtrl.pubCountMax);
        }
        String tenant = registration.getTenant();
        // ظעᣬһ
        DefaultPublisher<T> publisher = (DefaultPublisher<T>) findExisting(registration);
        if (null != publisher) {
            log.info(LogConstants.PREFIX_IMPORTANT + "[reuse-publisher] " + publisher);
            return publisher;
        }
        log.info("[Registrar] Register new publisher. dataId=" + dataId + ", groupId=" + groupId + ", clientId=" + clientId + ", tenant=" + tenant + ", !Server="
                + registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER) + ", !Center=" + registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER));
        try {
            publisher = new DefaultPublisher<T>(registration);
            clients.put(clientId, publisher);
        } catch (Exception e) {
            log.error("%s", "[Internal] Exception in registering subscriber: ", e);
        }
        return publisher;
    }

    /**
     * עǰעķݡעPublisherӦκʽʹãٴηݣעµķݡ
     *
     * @param publisher ϣעķ
     * @return Ƿעɹɹעڷ߲ڻע
     */
    public static boolean unregister(Publisher<?> publisher) {
        if (null == publisher) {
            throw new IllegalArgumentException("publisher is null");
        }
        log.info("[Registrar] Unregister " + publisher.getRegistration());
        try {
            ((DefaultPublisher<?>) publisher).unregister();
            return true;
        } catch (Exception e) {
            log.error("%s", "[Internal] Exception in unregistering subscriber: ", e);
            return false;
        }
    }

    public static DefaultPublisher<?> find(String clientId) {
        return clients.get(clientId);
    }

    /**
     * עɹɾ
     */
    static synchronized boolean remove(Publisher<?> publisher) {
        return clients.remove(publisher.getClientId()) != null;
    }

    // Ƿֳɵķ
    static DefaultPublisher<?> findExisting(PublisherRegistration<?> preg) {
        String dataId = preg.getDataId();
        String groupId = preg.getGroup();
        String tenant = preg.getTenant();
        String server = preg.getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER);
        String center = preg.getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER);
        for (DefaultPublisher<?> publisher : clients.values()) {
            String p_dataId = publisher.getDataId();
            String p_groupId = publisher.getRegistration().getGroup();
            String p_tenant = publisher.getRegistration().getTenant();
            String p_server = publisher.getRegistration().getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER);
            String p_center = publisher.getRegistration().getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER);
            if (publisher.isEnable() && p_dataId.equals(dataId) && p_groupId.equals(groupId) && p_tenant.equals(tenant)) {
                //ȼCenter>Server עͬʱ!Center!Server ,!ServerЧ
                if (center != null && p_center != null) {
                    if (p_center.equals(center)) {
                        return publisher;
                    }
                }
                if (center == null && p_center == null) {
                    if (StringUtils.equals(p_server, server)) {
                        return publisher;
                    }
                }
            }
        }
        return null;
    }

    // ߵ
    public static Iterator<DefaultPublisher<?>> publisherIterator() {
        return clients.values().iterator();
    }

    static {
        new Initialization();
    }

    public static Collection<DefaultPublisher<?>> AllPublishers() {
        return Collections.unmodifiableCollection(clients.values());
    }
}
