
package com.taobao.config.client;

import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;

/**
 * client
 * @author chaoshen
 */
public class LocalConfigInfo {

    private static Logger log = LoggerFactory.getLogger(LocalConfigInfo.class);

    /**Ĭϻ**/
    public static final String DEFAULT_ENV = "DEFAULT_ENV";
    /**Ĭ⻧**/
    public static final String DEFAULT_TENANT = "DEFAULT_TENANT";
    /**ĬIpGroup**/
    public static final String DEFAULT_IPGROUP = "default";
    /**мļͳһָĿ¼*/
    public static final String JM_LOCAL_PATH;
    /**configclientļͳһĿ¼*/
    public static final String CC_ROOT_PATH;
    static final boolean IsWindows = System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0;
    /**configclientػĿ¼*/
    static final public String SNAPSHOT_ROOT;
    /**configclient־Ŀ¼*/
    public static final String LOG_PATH;
    public static final String REMOTING_LOG_PATH;
    public static final String FAILOVER_DATA_PATH;
    public static final String FAILOVER_TRIGGER_PATH;
    /**configclient version*/
    private static String CLIENT_VERSION = "unknown";
    public static final String DATA_FILE_PATTERN;
    public static final String META_DATA_FILE_PATTERN;
    /**configclient */
    public static final String SERVER_CON_PUB_TYPE = "pub";
    public static final String SERVER_CON_SUB_TYPE = "pub";


    /**̬ʼ*/
    static {
        /**ʼĿ¼*/
        //-DJM.LOG.PATH=/home/admin/logs
        JM_LOCAL_PATH = System.getProperty("JM.LOG.PATH", System.getProperty("user.home"));
        CC_ROOT_PATH = JM_LOCAL_PATH + File.separator + "configclient";
        SNAPSHOT_ROOT = CC_ROOT_PATH + File.separator + "snapshot";
        LOG_PATH = CC_ROOT_PATH + File.separator + "logs" + File.separator + "config.client.log";
        REMOTING_LOG_PATH = CC_ROOT_PATH + File.separator + "logs" + File.separator + "remoting.log";
        FAILOVER_DATA_PATH = CC_ROOT_PATH + File.separator + "data";
        FAILOVER_TRIGGER_PATH = CC_ROOT_PATH + File.separator + "failover";
        DATA_FILE_PATTERN = SNAPSHOT_ROOT + File.separator + "{0}" + File.separator + "{1}" + File.separator + "{2}-{3}.dat";
        META_DATA_FILE_PATTERN = SNAPSHOT_ROOT + File.separator + "{0}" + File.separator + "{1}" + File.separator + "{2}-{3}-withMeta.dat";
        /**ȡǰversion*/
        try {
            InputStream in = ConfigClientLogger.class.getClassLoader()
                    .getResourceAsStream("configclient.properties");
            Properties props = new Properties();
            props.load(in);
            String val = props.getProperty("version");
            if (val != null) {
                CLIENT_VERSION = val;
            }
            log.info("CLIENT_VERSION:" + CLIENT_VERSION);
        } catch (Exception e) {
            log.error("version", "read configclient.properties", e);
        }
    }

    public static String getVersion(){
        return CLIENT_VERSION;
    }

}
