
package com.taobao.config.client;

import com.taobao.config.client.exception.ConfigClientException;
import com.taobao.config.client.metrics.ConfigClientMetrics;
import com.taobao.config.client.exception.ExcEventDispatch;

/**
 * ConfigClientʼ߼
 * 
 * @author JIUREN
 *
 */
public class Initialization {

    static {
        //init log
        try {
            ConfigClientLogger.getLogger(Initialization.class);
            ConfigClientSetting.initSetting();
            EnvironmentProbe.probe();
            RunMode.checkRunMode(); // check run mode on startup
            if(System.getProperty("JM.CS.LOG.DETAIL","true").equals("true")) {
                DumpServiceStatus.getInstance().start();//dump service status
            }
            ConfigClientMetrics.initMetrics();
            ExcEventDispatch.init();
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("configclient initial error, sorry about exit jvm,  exception:" + e);
            new ConfigClientException("Env-error","configclient initial error, sorry about exit jvm,  exception:",e).printStackTrace();
            System.exit(0);
        }
    }
}
