package com.taobao.config.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import com.taobao.middleware.logger.Logger;

/**
 * ¼ĺͷࡣ
 */
public class EventDispatcher {

    /**
     * ¼
     */
    static public void addEventListener(EventListener listener) {
        for (Class<? extends Event> type : listener.interest()) {
            getListenerList(type).addIfAbsent(listener);
        }
    }

    /**
     * ¼ȷ¼ʾ¼֪ͨжӦļ
     */
    static public void fireEvent(Event event) {
        if (null == event) { // 
            return;
        }

        // ¼ʾ¼
        for (Event implyEvent : event.implyEvents()) {
            try {
                if (event != implyEvent) { // ѭ
                    fireEvent(implyEvent);
                }
            } catch (Exception e) {
                log.error("%s",e.toString(), e);
            }
        }

        for (EventListener listener : getListenerList(event.getClass())) {
            try {
                listener.onEvent(event);
            } catch (Exception e) {
                log.error("%s",e.toString(), e);
            }
        }
    }

    // ̰߳ȫ
    static synchronized CopyOnWriteArrayList<EventListener> getListenerList(
            Class<? extends Event> eventType) {
        CopyOnWriteArrayList<EventListener> listeners = listenerMap.get(eventType);
        if (null == listeners) {
            listeners = new CopyOnWriteArrayList<EventListener>();
            listenerMap.put(eventType, listeners);
        }
        return listeners;
    }

    // ========================

    protected static final Logger log = ConfigClientLogger.getLogger(EventDispatcher.class);
    
    static final Map<Class<? extends Event>, CopyOnWriteArrayList<EventListener>> listenerMap //
    = new HashMap<Class<? extends Event>, CopyOnWriteArrayList<EventListener>>();

    // ========================

    /**
     * Client¼
     */
    static public abstract class Event {
        /**
         * ¼ܰʾ¼ĬʵΪա
         */
        @SuppressWarnings("unchecked")
        protected List<Event> implyEvents() {
            return Collections.EMPTY_LIST;
        }
    }

    /**
     * ¼
     */
    static public abstract class EventListener {
        public EventListener() {
            EventDispatcher.addEventListener(this); // ԶעEventDispatcher
        }
        
        /**
         * Ȥ¼б
         */
        abstract public List<Class<? extends Event>> interest();

        /**
         * ¼
         */
        abstract public void onEvent(Event event);
    }
}
