
package com.taobao.config.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import com.taobao.config.common.InternalDataID;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;

/**
 * жϻǷһǨƵһǨƺcacheҪɾ
 * 
 * жǨƵİ취ǣcacheеĵַбԱȣн˵ûǨƻ
 * ˵лǨơѱcacheȫա
 * 
 * @author JIUREN
 *
 */
public class EnvironmentProbe {

    static public void probe() {
        if (isEnvironmentChanged()) {
            log.warn(LogConstants.PREFIX_IMPORTANT + "environment changed. clear cache.");
            CachePersist.clear();
        } else {
            log.info(LogConstants.PREFIX_IMPORTANT + "environment ok.");
        }
//        ServerListManagerFactory.getFirstDefaultServerListManager().start();
    }

    static boolean isEnvironmentChanged() {
        List<String> cacheUrls = serverUrlsFromCache();
        //TODO AddressServerService
        List<String> apacheUrls = ServerListManager.getServerListByAs(null);
        log.info("[apache-urls] " + apacheUrls);
        log.info("[cache-urls] " + cacheUrls);
        return !apacheUrls.equals(cacheUrls);
    }

    // cacheеserverַб֤ΪNULL
    static List<String> serverUrlsFromCache() {
        List<Object> cacheData = CachePersist.initialData(InternalDataID.SERVER_LIST, null, LocalConfigInfo.DEFAULT_ENV);
        if (null == cacheData || cacheData.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> urls = new ArrayList<String>();
        for (Object item : cacheData) {
            urls.add((String) item);
        }
        return urls;
    }

    // ====================
    static private final Logger log = ConfigClientLogger.getLogger(EnvironmentProbe.class);
}
