/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2016 All Rights Reserved.
 */

package com.taobao.config.client;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;

import com.taobao.middleware.logger.Logger;

/**
 * dumpӦעᵽConfigClientеPublisherSubscriberstatus<br>
 * appopsԸҪöӦļ,ʽ<br>
 * publisherĸʽ cspublisher|com.taobao.wireless.sirius.trade.lifeservice.hsfprovider.SecondPartyOrderService:1.0.0|HSF|default|true<br>
 * subscriberĸʽcssubscriber|com.taobao.cartscache.client.carts|DEFAULT_GROUP|64
 *
 * @author en.xuze@alipay.com
 * @version $Id: DumpServiceStatus.java, v 0.1 201685 3:46:28 en.xuze@alipay.com Exp $
 */
public class DumpServiceStatus {

    private static Logger jesusislordLogger = ConfigClientLogger.getJesusislordLogger();
    private static String PUBLISHER_PREFIX = "|cspublisher";
    private static String SUBSCRIBER_PREFIX = "|cssubscriber";
    private static String CONNECION_STATUS = "|csreconnected";
    private static final String MESSAGG_SEPARATOR = "|";
    private static DumpServiceStatus dumpServiceStatus = new DumpServiceStatus();

    public static DumpServiceStatus getInstance() {
        return dumpServiceStatus;
    }

    private DumpServiceStatus() {
    }

    public void start() {
        ConfigClientTimerService.timer.scheduleWithFixedDelay(new DumpWorker(), 1L, 30L, TimeUnit.MINUTES);
    }

    private class DumpWorker implements Runnable {

        public void run() {
            if (ConfigClientPerfCtrl.isDumpServiceStatus()) {
                try {
                    jesusislordLogger.info("start dump service status... version=" + LocalConfigInfo.getVersion());
                    int pubCount = 0;
                    int synchronizedPubCount = 0;
                    int unsynchronizedPubCount = 0;
                    int subCount = 0;
                    int getAddressSubCount = 0;
                    int ungetAddressSubCount = 0;
                    //publisher
                    Iterator<DefaultPublisher<?>> publisherIterator = PublisherRegistrar.publisherIterator();
                    while (publisherIterator.hasNext()) {
                        DefaultPublisher<?> defaultPublisher = (DefaultPublisher<?>) publisherIterator.next();
                        StringBuffer sbBuffer = new StringBuffer(PUBLISHER_PREFIX).append(MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultPublisher.getDataId()).append(MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultPublisher.getRegistration().getGroup()).append(MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultPublisher.getEnv()).append(MESSAGG_SEPARATOR);
                        boolean isSynchronized = defaultPublisher.isSynchronized();
                        sbBuffer.append(isSynchronized);
                        if (isSynchronized) {
                            synchronizedPubCount++;
                            jesusislordLogger.info(sbBuffer.toString());
                        } else {
                            unsynchronizedPubCount++;
                            jesusislordLogger.error("", sbBuffer.toString());
                        }
                        pubCount++;
                    }
                    //subscriber
                    Iterator<DefaultSubscriber> subsriberIterator = SubscriberRegistrar.subscriberIterator();
                    while (subsriberIterator.hasNext()) {
                        DefaultSubscriber defaultSubscriber = (DefaultSubscriber) subsriberIterator.next();
                        StringBuffer sbBuffer = new StringBuffer(SUBSCRIBER_PREFIX).append(MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultSubscriber.getDataId()).append(MESSAGG_SEPARATOR);
                        sbBuffer.append(defaultSubscriber.getRegistration().getGroup()).append(MESSAGG_SEPARATOR);
                        int dataSize = defaultSubscriber.dataSize();
                        sbBuffer.append(dataSize);
                        if (dataSize > 0) {
                            getAddressSubCount++;
                            jesusislordLogger.info(sbBuffer.toString());
                        } else {
                            ungetAddressSubCount++;
                            jesusislordLogger.error("", sbBuffer.toString());
                        }
                        subCount++;
                    }
                    //9600ӵȶ
                    jesusislordLogger.info("multiConnections=" + ConfigClientPerfCtrl.isMultiConnections());
                    for (Iterator<String> iterator = ServerListManagerFactory.dumpConnectionStatus().iterator(); iterator.hasNext(); ) {
                        String connectionStatus = (String) iterator.next();
                        StringBuffer sbBuffer = new StringBuffer(CONNECION_STATUS);
                        sbBuffer.append(MESSAGG_SEPARATOR);
                        sbBuffer.append(connectionStatus);
                        jesusislordLogger.info(sbBuffer.toString());
                    }
                    //serverlistMgr status
                    jesusislordLogger.info("multiConnections=" + ConfigClientPerfCtrl.isMultiConnections());
                    jesusislordLogger.info(ServerListManagerFactory.dumpDetail());

                    jesusislordLogger.info("dump service status: pubCount={},syncPubCount={},unSyncPubCount={},subCount={},getAddressSubCount={},unGetAddressSubCount={}",
                            new Object[]{pubCount, synchronizedPubCount, unsynchronizedPubCount, subCount, getAddressSubCount, ungetAddressSubCount});
                } catch (Exception e) {
                    jesusislordLogger.error("dump-status-error", e.getMessage());
                }
            }
        }
    }
}
