
package com.taobao.config.client;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

import com.taobao.config.client.SubscriberDataObserver.NewDataObserver;
import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcListener;
import com.taobao.config.client.exception.ExcRole;

import com.taobao.config.client.utils.AttributeUtils;
import com.taobao.config.client.utils.MapUtils;
import com.taobao.config.client.utils.ObserverDataUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.Revision;
import com.taobao.config.common.protocol.AttributeElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.SubscriberRegReqPacket;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;

/**
 * @see SubscriberRegistrar
 *
 * @author wufeng, JIUREN
 * 
 * ʼ汾Ϊ0. ӶϿģʽ任汾ҪΪ0
 */
public class DefaultSubscriber extends DefaultDataClient implements Subscriber {

    private volatile Map<String, Double> weightValue = new HashMap<String, Double>();

    public Map<String, Double> getWeightValue() {
        return weightValue;
    }


    public boolean setWeightValue(Map<String, Double> weightValue) {

        if(!this.weightValue.equals(weightValue)) {
            this.weightPushCount.incrementAndGet();
            this.weightValue = weightValue;
            return true;
        }
        return false;
    }

    public List<Object> peekData() {
        if (data.getData() == null) {
            return null;
        }
        try {
            return Collections.unmodifiableList(data.getData());
        } catch (Throwable t) {
            return null;
        }
    }

    public Map<String, List<ObserverData>> peekDataWithMeta() {
        if (data.getObserverDataGroups() == null) {
            return null;
        }
        try {
            return Collections.unmodifiableMap(data.getObserverDataGroups());
        } catch (Throwable t) {
            return null;
        }
    }

    public SubscriberRegistration getRegistration() {
        return (SubscriberRegistration) registration;
    }

    public DefaultSubscriber(SubscriberRegistration registration) {
        super(registration);
        // For later reusing after disconnection.
        this.regRequest = new SubscriberRegReqPacket(registration.getDataId(), registration.getClientId(), registration.getDatumId());
        for (Map.Entry<String, Serializable> attribute : registration.getAllAttributes()) {
            regRequest.setAttribute(attribute.getKey(), attribute.getValue());
        }
        observers = new CopyOnWriteArrayList<SubscriberDataObserver>();
        /** ʼ **/
        List<Object> initial = CachePersist.initialData(getDataId(), getRegistration().getGroup(),this.serverMgr.getEnv());
        Map<String, List<ObserverData>> initialWithMeta = CachePersist.initialDataWithMeta(getDataId(), getRegistration().getGroup(),this.serverMgr.getEnv());
        if(!MapUtils.isEmptyValue(initialWithMeta)) {
            data = new RevisedData(Revision.UNINITIALIZED_REVISION, initialWithMeta);
            log.info("[init-subscriber] " + this + ", initial dataWithMeta, dataMsg=" + getDataMsg(initialWithMeta));
        } else if (null != initial && (!initial.isEmpty())) {
            data = new RevisedData(initial, Revision.UNINITIALIZED_REVISION);
            log.info("[init-subscriber] " + this + ", initial data, dataSize=" + initial.size());
        } else {
            data = new RevisedData(null, Revision.UNINITIALIZED_REVISION, null);
            log.info("[init-subscriber] no init data file. " + this);
        }
        super.serverMgr.incrementSubCount();
        signalWorker();
    }

    /*
     * TODO: Server-side-implementation
     */
    public synchronized void unregister() {
        boolean unregister = super.setDisable();
        if (unregister) {
            super.serverMgr.decrementSubCount();
        }
    }
    public volatile boolean isExistSubMetaDataObserver = false;
    // ݼ
    @Override
    synchronized public void setDataObserver(SubscriberDataObserver observer) {

        observers.addIfAbsent(observer);
        if(observer instanceof SubMetaDataObserver) {
            isExistSubMetaDataObserver =true;
            if(null != data.getObserverDataGroups()) {
                ((SubMetaDataObserver)observer).handleDataWithMeta(getDataId(), data.getObserverDataGroups());
            }
        }
        if (null != data.getData()) {
            if ((observer instanceof NewDataObserver) && data.getRevision().equals(Revision.UNINITIALIZED_REVISION)) {
                ((NewDataObserver) observer).onInitialLocalData(data.getData());
            } else {
                if (observer instanceof WeightDataObserver) {
                    //weightValueδ棬readOnlyMapViewempty
                    Map<String, Double> readOnlyMapView = Collections.unmodifiableMap(this.weightValue);
                    ((WeightDataObserver) observer).handleData(getDataId(), data.getData(), readOnlyMapView);
                } else if (observer instanceof SubWeightDataObserver) {
                    ((SubWeightDataObserver) observer).handleData(getDataId(), data.getData());
                } else if(observer instanceof SubMetaDataObserver) {

                } else {
                    observer.handleData(getDataId(), data.getData());
                }
            }
        }
    }

    @Override
    @Deprecated
    public SubscriberDataObserver getDataObserver() {
        return observers.isEmpty() ? null : observers.get(0);
    }

    @Override
    public synchronized Subscription getSubscription() {
        DefaultSubscription observer = new DefaultSubscription();
        setDataObserver(observer);
        return observer;
    }

    @Override
    ServerListManager initServerManager() {
        String server = registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_SERVER);
        String center = registration.getLocalAttribute(LocalAttribute.ATTRIBUTE_CENTER);
        InstanceMetaData instanceMetaData = registration.getInstanceMetaData();
        // ȼCenter>Server עͬʱ!Center!Server ,!ServerЧ
        if (StringUtils.isNotBlank(center)) {
            return ServerListManagerFactory.getServerListManager(LocalAttribute.ATTRIBUTE_CENTER, center,
                    LocalConfigInfo.SERVER_CON_SUB_TYPE, instanceMetaData);
        } else if(StringUtils.isNotBlank(server)) {
            return ServerListManagerFactory.getServerListManager(LocalAttribute.ATTRIBUTE_SERVER, server,
                    LocalConfigInfo.SERVER_CON_SUB_TYPE, instanceMetaData);
        } else {
            return ServerListManagerFactory.getDefaultServerListManager(LocalConfigInfo.SERVER_CON_SUB_TYPE, instanceMetaData);
        }
    }

    @Override
    synchronized boolean isSynchronized() {
        return isEnable() && isRegistered();
    }

    @Override
    public void addPackage(ProtocolPackage packagee) {
        if (cleanUpIfNecessary() || !isEnable()) {
            return;
        }
        InstanceMetaData instanceMetaData = registration.getInstanceMetaData();
        AttributeUtils.setInstanceMetaInPackage(packagee, instanceMetaData);
        packagee.addElement(regRequest);
        // support ZIP compression
        packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_TENANT, "true"));
        packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_ZIP, "true"));
        packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_WEIGHT, "true"));
        packagee.addElement(new AttributeElement(AttributeElement.LANG, "java"));
        packagee.addElement(new AttributeElement(AttributeElement.VERSION, LocalConfigInfo.getVersion()));
        packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_SINGLE_WEIGHT, "true"));
        packagee.addElement(new AttributeElement(AttributeElement.ATTRIBUTE_METADATA_GROUP, "true"));

        log.info("[Deliver] " + registration);
    }

    /**
     * ݣٱȽϰ汾
     */
    public void update(Revision revision, List<Object> datas, Map<String, List<ObserverData>> observerDatas) {
        if (isDisable()) {
            return;
        }
        /**dataź˳Ҫ*/
        if(datas==null && observerDatas != null){
            data = new RevisedData(revision, observerDatas);
            int size = (null == observerDatas) ? 0 : observerDatas.size();
            log.info(LogConstants.PREFIX_IMPORTANT + "[subscriber-update] " + this + ", dataWithMeta revision="
                    + data.getRevision() + ", observerDatas=" + getDataMsg(observerDatas));
        } else {
            data = new RevisedData(datas, revision);
            int size = (null == datas) ? 0 : datas.size();
            log.info(LogConstants.PREFIX_IMPORTANT + "[subscriber-update] " + this + ", revision=" + data.getRevision() + ", count=" + size);
        }
        dataPushCount.incrementAndGet();

        notifyObServer();
    }

    public void notifyObServer() {
        if (isEnable()) {
            ConfigClientNotifier.notify(this);
        } else {
            log.error("s%","[subscriber] disable subscriber received push data.");
        }
    }

    /** ź*/
    private AtomicInteger dataPushCount = new AtomicInteger();
    /** Ȩź*/
    private AtomicInteger weightPushCount = new AtomicInteger();

    /**
     * ֪ͨеļ. Notify̵߳á
     */
    void signalObservers() {
        if (data.getData() == null && data.getObserverDataGroups() == null) {
            return;
        }
        List<Object> readOnlyDataView = null;
        boolean isDataNotNull = data.getData() != null;
        boolean isObserverDataNotNull = data.getObserverDataGroups() !=null;
        if(isDataNotNull){
            readOnlyDataView = Collections.unmodifiableList(data.getData());
        }
        Map<String, Double> readOnlyWeightMapView = Collections.unmodifiableMap(this.weightValue);
        /** ־ƴ**/
        StringBuilder notifierLogSb = new StringBuilder();
        notifierLogSb.append("[Notifier] Notify " + this.toString());
        notifierLogSb.append(", rev=" + data.getRevision());
        notifierLogSb.append(", dataPushCount=" + dataPushCount);
        notifierLogSb.append(", weightPushCount=" + weightPushCount);
        notifierLogSb.append(", observers.size=" + observers.size());
        notifierLogSb.append(isDataNotNull ? "" : "data is null");
        notifierLogSb.append(isObserverDataNotNull ? "" : "ObserverData is null");
        boolean isDataPush = isNeedDataPushAndClear();
        boolean isWeightPush = isNeedWeightPushAndClear();
        /** ־ƴ ӡ**/
        notifierLogSb.append(", isDataPush=" + isDataPush);
        notifierLogSb.append(", isWeightPush=" + isWeightPush);
        log.info(notifierLogSb.toString());

        for (SubscriberDataObserver observer : observers) {
            try {
                if (observer instanceof WeightDataObserver && isDataNotNull) {

                    ((WeightDataObserver) observer).handleData(getDataId(), readOnlyDataView, readOnlyWeightMapView);

                } if (observer instanceof  SubWeightDataObserver) {

                    if(isDataPush && isDataNotNull){
                        log.info("[Notifier-data-detail] Notify " + this + ", rev=" + data.getRevision()+",size=" + (data.getData()!=null ? String.valueOf(data.getData().size()) : "null"));
                        observer.handleData(getDataId(), Collections.
                                unmodifiableList(data.getData()));
                    }
                    if(isWeightPush){
                        log.info("[Notifier-weight-detail] Notify " + this + ", rev=" + data.getRevision()+",size="+(this.weightValue!=null?String.valueOf(this.weightValue.size()):"null"));
                        ((SubWeightDataObserver)observer).handleWeight(getDataId(),
                                Collections.unmodifiableMap(this.weightValue));
                    }
                } if (observer instanceof SubMetaDataObserver && isObserverDataNotNull) {
                    if(isDataPush) {
                        Map<String, List<ObserverData>> observerDataMap = Collections.unmodifiableMap(data.getObserverDataGroups());
                        String dataDetailMsg = getDataMsg(observerDataMap);
                        log.info("[Notifier-dataGroup-detail] Notify " + this + ", rev=" + data.getRevision()+",dataDetailMsg=" + dataDetailMsg +",subIpGroups="+getRegistration().getSubIpGroups());
                        ((SubMetaDataObserver)observer).handleDataWithMeta(getDataId(),
                                observerDataMap);
                    }
                } else {
                    if(isDataNotNull){
                        observer.handleData(getDataId(), readOnlyDataView);
                    }
                }
            } catch (Throwable t) {
                log.warn("Exception in data observer of subscriber " + registration.getClientName() + " for data " + registration.getDataId() + ": ", t);
            }
        }
    }

    private String getDataMsg(Map<String, List<ObserverData>> observerDataMap) {
        StringBuilder dataDetailMsg = new StringBuilder("[");
        if(observerDataMap!=null){
            for(Map.Entry<String, List<ObserverData>> entry : observerDataMap.entrySet()){
                String ipGroup = entry.getKey();
                List<ObserverData> observerDataList = entry.getValue();
                dataDetailMsg.append("(");
                dataDetailMsg.append(ipGroup);
                dataDetailMsg.append(",");
                dataDetailMsg.append(observerDataList!=null?observerDataList.size():"null");
                dataDetailMsg.append(")");
            }
        }else {
            dataDetailMsg.append("null");
        }
        dataDetailMsg.append("]");
        return dataDetailMsg.toString();
    }

    private boolean isNeedDataPushAndClear() {
        boolean isDataPush = false;
        if( dataPushCount.get() > 0 ) {
            /** ֵ㣬˳ܵߵ ֤һ*/
            dataPushCount.getAndSet(0);
            /** ΪһԱ֤ҪҪȡµ*/
            isDataPush = true;
        }
        return isDataPush;
    }

    private boolean isNeedWeightPushAndClear() {
        boolean isWeightPush = false;
        if( weightPushCount.get() > 0 ) {
            /** ֵ㣬˳ܵߵ ֤һ*/
            weightPushCount.getAndSet(0);
            /** ΪһԱ֤ҪҪȡµ*/
            isWeightPush = true;
        }
        return isWeightPush;
    }

    public Revision revision() {
        return data.getRevision();
    }

    public int dataSize() {
        return data.getData() == null ? 0 : data.getData().size();
    }

    @Override
    public String toString() {
        return "Subscriber (" + registration.getDataId() + ", " + registration.getGroup() +
                ", " + getClientId() + ", "+(getRegistration().getSubIpGroups()!=null?getRegistration().getSubIpGroups():null)+")";
    }

    public List<Object> getData() {
        return this.data.getData();
    }

    public Map<String, List<ObserverData>> getObserverDataGroups() {
        return this.data.getObserverDataGroups();
    }

    static protected final Logger log = ConfigClientLogger.getLogger(DefaultSubscriber.class);
    final private SubscriberRegReqPacket regRequest;
    private volatile RevisedData data;
    protected final CopyOnWriteArrayList<SubscriberDataObserver> observers;

    @Override
    public void addExcListener(ExcListener listener) {
        ExcEventDispatch.addListener(this.getRegistration().getDataId(),//
                this.getRegistration().getGroup(), //
                this.getRegistration().getTenant(),//
                ExcRole.SUB, listener);
    }
}

class RevisedData implements Serializable {

    /**
     * Create an instance with uninitialized revision.
     */
//    public RevisedData(List<Object> data) {
//        this.data = data;
//        this.revision = Revision.UNINITIALIZED_REVISION;
//    }
//
    public RevisedData(List<Object> data, Revision revision) {
        this.data = data;
        this.observerDataGroups = ObserverDataUtils.getObserverDataMapFromData(data);
        this.revision = revision;
    }

    public RevisedData(List<Object> data, Revision revision, Map<String, List<ObserverData>> observerDataGroups) {
        this.data = data;
        this.revision = revision;
        this.observerDataGroups = observerDataGroups;
    }

    public RevisedData(Revision revision, Map<String, List<ObserverData>> observerDataGroups) {
        this.observerDataGroups = observerDataGroups;
        this.data = ObserverDataUtils.getDataFromObserverDataMap(observerDataGroups);
        this.revision = revision;
    }

    public List<Object> getData() {
        return data;
    }

    public Map<String, List<ObserverData>> getObserverDataGroups() {
        return observerDataGroups;
    }

    public Revision getRevision() {
        return revision;
    }

    public String toString() {
        return "RevisedData(" + revision.getRevision() + ", "
                + (data!=null?data.toString():"null") + ", "
                + (observerDataGroups!=null?observerDataGroups.toString():"null")+")";
    }

    private final List<Object> data;
    private Map<String, List<ObserverData>> observerDataGroups;
    private final Revision revision;
    private static final long serialVersionUID = 1L;
}
