package com.taobao.config.client;

import java.util.concurrent.atomic.AtomicBoolean;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;

/**
 * @author wufeng
 */
public abstract class DefaultDataClient implements DataClient {

    DefaultDataClient(DataClientRegistration registration) {
        if (registration == null) {
            throw new NullPointerException("Registration is null.");
        }
        this.registration = registration;
        this.serverMgr = initServerManager();
    }

    void signalWorker() {
        this.serverMgr.getConfigClientWork().signal();
    }

    protected boolean isEnable() {
        return isEnable.get();
    }
    protected boolean isDisable() {
        return !isEnable.get();
    }
    protected boolean isRegistered() {
        return isRegistered.get();
    }
    protected boolean isNotRegistered() {
        return !isRegistered.get();
    }

    /**
     * עҵӦServerManager
     */
    abstract ServerListManager initServerManager();

    /**
     * ڸclientЧ£жǷͬ
     */
    abstract boolean isSynchronized();

    abstract void addPackage(ProtocolPackage pp);
    

    /**
     * Set isEnable with FALSE and return its previous value.
     */
    protected synchronized boolean setDisable() {
        return isEnable.getAndSet(false);
    }

    // Implement interface DataClient
    public String getClientId() {
        return registration.getClientId();
    }
    public String getDataId() {
        return registration.getDataId();
    }

    public DataClientRegistration getRegistration() {
        return registration;
    }


    // Implement interface RegisterResultObserver
    synchronized public void handleRegisterResult(boolean result, Error error) {
        isRegistered.set(true);
        this.registerResult = result;
        this.registerError = error;

        if (error == null) {
            log.info("[Register-ok] " + this);
        } else {
            log.warn("[Register-error] " + this + ", " + error);
        }
    }

    synchronized public void onServerDisconnected() {
        isRegistered.set(false);
        registerResult = false;
        registerError = null;
        signalWorker();
    }

    /**
     *
     * @return Whether this dataClient is cleaned or not.
     */
    protected boolean cleanUpIfNecessary() {
        if (isDisable() && isNotRegistered()) {
            if (this instanceof Publisher) {
                PublisherRegistrar.remove((Publisher<?>) this);
            } else if (this instanceof Subscriber) {
                SubscriberRegistrar.remove((Subscriber) this);
            }
            log.info("[direct-cleanup] " + this);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return registration.getClientId().hashCode();
    }


    //=================================
    static final Logger log = ConfigClientLogger.getLogger(DefaultDataClient.class);

    /*
     * Valid or not. TRUE -> FALSE
     */
    private final AtomicBoolean isEnable = new AtomicBoolean(true);

    private final AtomicBoolean isRegistered = new AtomicBoolean(false);

    protected volatile boolean registerResult = false; // Valid if isRegistered == true
    protected Error registerError = null;              // Valid if registerResult == false

    protected final DataClientRegistration registration;

    /** ip*/
    protected final ServerListManager serverMgr;

    public ServerListManager getServerListManager(){
        return serverMgr;
    }
}
