package com.taobao.config.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

import com.taobao.config.client.bean.InstanceMetaData;
import com.taobao.config.client.services.ConfigClientConstants;
import com.taobao.config.common.protocol.AttributeElement;

/**
 * @author wufeng
 *
 */
class DataClientRegistration extends ConfigClientRegistration {

	public String getDataId() {
		return dataId;
	}

	public String getDatumId() {
		return datumId;
	}

	/**
	 * 
	 *
	 * <p>ݵĶߺͷ߿ԱΪ飬ֻյλͬһеķݡ
	 * δķߺͶ߽һȫΨһĬУκʽָ˴˸롣
	 *
	 * @param group 
	 */
	public void setGroup(final String group) {
		setAttribute(AttributeElement.ATTRIBUTE_GROUP, group);
	}

	public String getGroup() {
	    String group = getStringAttribute(AttributeElement.ATTRIBUTE_GROUP);
        return (null != group ? group : "DEFAULT_GROUP");
	}

	/**
	 * 
	 *
	 * <p>ݵĶߺͷ߿ԱĬϻȫַΧڡԪΧڡΧڡ
	 * ĬΪȫ򣬷ֻܱڸ֪
	 * ConfigClientConstants ѡ
	 * @param scope ͬΧ
	 */
	public void setScope(final ConfigClientConstants.SCOPE scope) {
		setAttribute(AttributeElement.ATTRIBUTE_SCOPE, scope.toString());
	}

	public String getScope() {
		String scope = getStringAttribute(AttributeElement.ATTRIBUTE_SCOPE);
		return (null != scope ? scope : ConfigClientConstants.SCOPE.global.toString());
	}


	public InstanceMetaData getInstanceMetaData() {
		return instanceMetaData;
	}

	public void setInstanceMetaData(InstanceMetaData instanceMetaData) {
		this.instanceMetaData = instanceMetaData;
	}

	/**
     * ⻧
     * <p>
     * Բͬ⻧棬񲻿ɼδ⻧ģˣĬȫΪXXX⻧
     * @param  tenant
     */
    public void setTenant(final String tenant) {
        setAttribute(AttributeElement.ATTRIBUTE_TENANT, tenant);
    }

    public String getTenant() {
        String tenant = getStringAttribute(AttributeElement.ATTRIBUTE_TENANT);
        return (null != tenant ? tenant : "DEFAULT_TENANT");
    }

	protected DataClientRegistration(final String clientName, final String dataId, final String datumId) {
	    super(clientName, instanceIdKeeper.getNewInstanceId(clientName));
		if (dataId == null) {
			throw new IllegalArgumentException("dataId is null.");
		}
		this.dataId = dataId;
		this.datumId = datumId;
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		return prime * (prime + dataId.hashCode()) + ((datumId == null) ? 0 : datumId.hashCode());
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (! (obj instanceof DataClientRegistration))
			return false;
		final DataClientRegistration other = (DataClientRegistration) obj;
		if (! dataId.equals(other.dataId))
			return false;
		if (datumId == null) {
			if (other.datumId != null)
				return false;
		} else if (!datumId.equals(other.datumId))
			return false;
		return true;
	}

    private static final InstanceIdKeeper instanceIdKeeper = new InstanceIdKeeper();
	private final String dataId;
	private final String datumId;
	private InstanceMetaData instanceMetaData;
}

/**
 * Keep instanceMetaData ID unique for same instanceMetaData name.
 *
 * @author wufeng
 */
class InstanceIdKeeper {

   // TODO: Test carefully in concurrent environment.
   public int getNewInstanceId(final String instanceName) {
       if (null == instanceName) {
           throw new IllegalArgumentException("instanceName is null");
       }
       final AtomicInteger newId = new AtomicInteger(0);
       AtomicInteger currentId = instanceIdMap.putIfAbsent(instanceName, newId);
       if (currentId == null) {
           currentId = newId;
       }
       return currentId.incrementAndGet();     // Increase first, thus the ID is started from 1.
   }

   private static final ConcurrentHashMap<String /*combinedId*/, AtomicInteger /*instanceId*/> instanceIdMap
           = new ConcurrentHashMap<String, AtomicInteger>();
}
