
package com.taobao.config.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.taobao.config.client.remoting.ConnectionListener;
import com.taobao.config.client.remoting.ConnectionRequestProcessor;
import com.taobao.config.common.ConfigServerURL;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.config.common.protocol.VersionElement;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Client;
import com.taobao.remoting.ClientManager;
import com.taobao.remoting.ClientManager.ClientFuture;
import com.taobao.remoting.Connection;
import com.taobao.remoting.IOEventListener;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.RemotingException;
import com.taobao.remoting.RequestProcessor;
import com.taobao.remoting.TRConstants;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/1/16 5:12
 */
public class ConnectionProxy {

    private static final Logger log = ConfigClientLogger.getLogger(ConnectionProxy.class);
    // Connection parameters
    private static int HEARTBEAT_PERIOD = 5; // In seconds
    private static int CONNECTION_TIMEOUT = 3000; // In milliseconds
    private static int COMMUNICATION_TIMEOUT = 3000; // In milliseconds
    private static String port = null;
    static {
        String definPort = System.getProperty("configserver.client.port");
        if (null != definPort) {
            port = definPort;
        }
    }
    // =====================================
    // Constants
    /**
     * global args
     */
    private static final String APP_NAME = ConnectionProxy.class.getPackage().toString();
    public static final ConcurrentMap<Connection, ServerListManager> allConnection = new ConcurrentHashMap<Connection, ServerListManager>();

    private List<IOEventListener> connectionListeners = new ArrayList<IOEventListener>(1);;
    private Map<Class<?>, RequestProcessor<?>> requestProcessors = new HashMap<Class<?>, RequestProcessor<?>>();
    private final ServerListManager serverMgr;
    protected volatile Client client = null;
    protected int reConnected = 0;//Ӵ

    ConnectionProxy(ServerListManager serverMgr) {
        this.serverMgr = serverMgr;
        connectionListeners.add(new ConnectionListener(serverMgr.getConfigClientWork()));
        requestProcessors.put(ProtocolPackage.class, new ConnectionRequestProcessor(serverMgr.getConfigClientWork()));
    }

    boolean connect() throws InterruptedException {
        if (!isConnected()) {
            client = roll();
        }
        return isConnected();
    }

    // Rolling servers to connect. ֱɹӲ˳
    //Ľ20160804FIXED:һ̨̨Խ,ɹ򷵻
    protected Client roll() throws InterruptedException {

        for (Iterator<ConfigServerURL> iter = serverMgr.iterator(); iter.hasNext();) {
            serverMgr.getConfigClientWork().waitUntilNormalMode();
            try {
                Client client = connectTo(iter.next(), connectionListeners, requestProcessors);
                if (null != client) {
                    return client;
                }
            } catch (final Exception e) {
                log.error("%s", "[Global] Unexpected exception in server rolling: ", e);
            }
            Thread.sleep(5000L);
        }
        return null;
    }

    protected Client redirectServer(ConfigServerURL configServerURL) throws InterruptedException {

        serverMgr.getConfigClientWork().waitUntilNormalMode();
        try {
            Client client = connectTo(configServerURL, connectionListeners, requestProcessors);
            if (null != client) {
                return roll();
            }
        } catch (final Exception e) {
            log.error("%s", "[Global] redirectServer Unexpected exception in server redirectServer: ", e);
        }
        return null;
    }

    public synchronized Client connectTo(ConfigServerURL address, List<IOEventListener> connListeners, Map<Class<?>, RequestProcessor<?>> requestProcessors) {
        log.info("[Global] Connecting to " + address + "...");
        final String remotingUrl = makeRemotingUrl(address);
        ClientFuture cf = getClientManager().getAsync(APP_NAME, remotingUrl, connectionListeners, requestProcessors);
        try {
            Client client = cf.get(-1);
            if (null != client && client.isConnected()) {
                log.info("[Global] Successfully connected to server: " + address);
                allConnection.put(client.getConnection(), serverMgr);
                reConnected++;
                return client;
            }
        } catch (final Exception e) {
            log.warn("Failed to connect to " + address + " due to " + e);
        }
        return null;
    }

    void close() {
        if (client == null) {
            return;
        }
        try {
            client.destroy();
        } catch (final Throwable t) {
            log.error("%s", "[Network] Failed to close connection due to " + t);
        }
    }

    boolean isConnected() {
        return client != null && client.isConnected();
    }

    // Explicitly throw RuntimeException to indicate the possibility of external API emphatically.
    ProtocolPackage sendReceive(final ProtocolPackage request) throws InterruptedException, RemotingException, RuntimeException {
        if (!isConnected())
            throw new IllegalStateException("Not connected");
        log.debug("[Message] Sending request: " + request.countElements() + " elements.");
        if (log.isDebugEnabled())
            dump(request);
        final Object object = client.invokeWithSync(request, null);
        if (!(object instanceof ProtocolPackage)) {
            log.debug("[Message] Invalid server response: " + (object == null ? "(NULL)" : object.getClass()));
            return null;
        }
        final ProtocolPackage response = (ProtocolPackage) object;
        log.debug("[Message] Server response: " + response.countElements() + " elements");
        if (log.isDebugEnabled())
            dump(response);
        return response;
    }

    void dump(final ProtocolPackage message) {
        for (final ProtocolElement element : message) {
            if (element.getClass() != VersionElement.class)
                log.debug("[Message] >> " + element);
        }
    }

    private String makeRemotingUrl(final ConfigServerURL address) {
        int idx = address.toString().indexOf('?');
        String query = idx > 0 ? address.toString().substring(idx) : "";
        StringBuilder addUrl = new StringBuilder();
        addUrl.append(address.getHost() + ":" + (port == null ? address.getPort() : port)  + "?");
        addUrl.append(TRConstants.SERIALIZE_TYPE_KEY + "=" + TRConstants.JAVA_SERIALIZE);
        addUrl.append("&" + TRConstants.AUTORECONNECT_KEY + "=false");
        addUrl.append("&" + TRConstants.HEARTBEAT_KEY + "=true");
        addUrl.append("&" + TRConstants.IDLE_TIMEOUT_KEY + "=" + String.valueOf(HEARTBEAT_PERIOD));
        addUrl.append("&" + TRConstants.CONNECT_TIMEOUT_KEY + "=" + String.valueOf(CONNECTION_TIMEOUT));
        addUrl.append("&" + TRConstants.TIMEOUT_TYPE_KEY + "=" + String.valueOf(COMMUNICATION_TIMEOUT));
        addUrl.append("&" + "_SERVERMGRCODE" + "=" + String.valueOf(this.serverMgr.hashCode()));
        addUrl.append("&" + query);
        return addUrl.toString();
    }

    // This method can be overridden to provide mock ClientManager.
    protected ClientManager getClientManager() {
        return Remoting.clientMgr();
    }

    public int getReConnected() {
        return reConnected;
    }


}
