
package com.taobao.config.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import com.taobao.config.client.exception.ExcEvent;
import com.taobao.config.client.exception.ExcEventDispatch;
import com.taobao.config.client.exception.ExcType;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

import com.taobao.config.client.processor.ElementProcessorHub;
import com.taobao.config.common.protocol.ProtocolElement;
import com.taobao.config.common.protocol.ProtocolPackage;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.Client;

/**
 * Created by xingxuechao@alibaba-inc.com
 * on:18/1/16 5:12
 */
public class ConfigClientWorker implements Runnable {

    private static final Logger log = ConfigClientLogger.getLogger(ConfigClientWorker.class);

    private static final ElementProcessorHub processorManager = new ElementProcessorHub();
    // To keep messages from configServer. Access is shared between deliverer thread and communication thread.
    private final BlockingQueue<ProtocolPackage> mailbox = new LinkedBlockingQueue<ProtocolPackage>(MAX_MAILBOX_SIZE);
    private static int MAX_MAILBOX_SIZE = 2048; // Number of slots
    private static final int SEND_BATCH = 32;

    /** worker ӵ server*/
    private final ServerListManager serverListManager;
    /** worker*/
    private volatile Client client = null;
    private volatile boolean isContinue = true;

    /** ź*/
    private BlockingQueue<Object> bell = new ArrayBlockingQueue<Object>(1);
    private Object bellItem = new Object();

    /**
     * worker Ϊ̣߳ĽӶ߳ά
     * @param serverListManager
     */
    public ConfigClientWorker(ServerListManager serverListManager) {
        this.serverListManager = serverListManager;
    }

    public ServerListManager getServerListManager() {
        return serverListManager;
    }

    public BlockingQueue<ProtocolPackage> getMailbox() {
        return mailbox;
    }

    /**
     * ȴֱģʽ worker߳ConfigClientWorker
     */
    public void waitUntilNormalMode() {

        while (RunMode.isFailoverMode()) {
            try {
                wait(TimeUnit.SECONDS.toMillis(5L));
            } catch (Exception e) {
                log.error("%s", "error when waiting for normal mode: " + e.toString(), e);
            }
        }
    }

    public void closeConnection() {
        if (client == null) {
            return;
        }
        try {
            client.destroy();
        } catch (final Throwable t) {
            log.error("%s", "[Network] Failed to close connection due to " + t);
        }
    }


    @Override
    public void run() {
        log.info("[Global] Deliverer thread is starting...");
        while (isContinue) {
            try {
                runOnce();
            } catch (Exception e) {
                log.error("%s", "[Internal] Unhandled exception in deliverer: ", e);
            } finally {
                try {
                    rest(3000L);
                } catch (Exception e) {
                    log.error("%s", "[Internal] rest is error Unhandled exception in deliverer: ", e);
                }
            }
        }
    }

    public void signal() {
        bell.offer(bellItem);
    }

    private void rest(long timeoutMs) throws InterruptedException {
        bell.poll(timeoutMs, TimeUnit.MILLISECONDS);
    }




        private void runOnce() throws InterruptedException {
            waitUntilNormalMode();
            // Process incoming messages first
            while (mailbox.size() > 0) {
                ProtocolPackage message;
                while ((message = mailbox.poll()) != null) {
                    handleServerMessage(message);
                }
            }
            // group by serverMgr
            Map<ServerListManager, List<DefaultDataClient>> clientGroups = new HashMap<ServerListManager, List<DefaultDataClient>>();
            // bug fix  workerϵ
            for (Iterator<?> iter = FluentIterator.asIterator(PublisherRegistrar.publisherIterator(), SubscriberRegistrar.subscriberIterator()); iter.hasNext();) {
                DefaultDataClient dataClient = (DefaultDataClient) iter.next();
                if (serverListManager == dataClient.serverMgr) {
                    List<DefaultDataClient> clients = clientGroups.get(dataClient.serverMgr);
                    if (null == clients) {
                        clients = new ArrayList<DefaultDataClient>();
                        clientGroups.put(dataClient.serverMgr, clients);
                    }
                    clients.add(dataClient);
                }
            }
            // send request by ServerMgr
            for (Map.Entry<ServerListManager, List<DefaultDataClient>> entry : clientGroups.entrySet()) {
                final ServerListManager serverMgr = entry.getKey();
                final List<DefaultDataClient> clients = entry.getValue();
                /** ֤עȱͳȥ*/
                Collections.sort(clients, new Comparator<DefaultDataClient>() {
                    @Override
                    public int compare(DefaultDataClient defaultDataClient, DefaultDataClient t1) {
                        if(defaultDataClient.isDisable()) return -1;
                        if(t1.isDisable()) return 1;
                        return 0;
                    }
                });
                final Iterator<DefaultDataClient> iter = clients.iterator();
                while (iter.hasNext()) {
                    final ProtocolPackage packagee = new ProtocolPackage();
                    // ֤ ݰ˳עİӦ÷ǰ
                    //  ע״̬İ
                    for (int actualCount = 0; iter.hasNext() && actualCount <= SEND_BATCH; actualCount++) {
                        DefaultDataClient dataClient = iter.next();
                        if (!dataClient.isSynchronized()) {
                            dataClient.addPackage(packagee);
                        }
                    }
                    if (packagee.countElements() > 1) {
                        //ûнɹbreak,´
                        if (!ensureConnected(serverMgr)) {
                            break;
                        }
                        try {
                            handleServerMessage(serverMgr.connectionProxy.sendReceive(packagee));
                        } catch (InterruptedException i) {
                            //TODO ExcEventDispatch.fireEvent(new ExcEvent(ExcType.UKNOWN, //
                            //"[Network] Request failed due to " + t));
                            throw i;
                        } catch (Throwable t) {
                            log.error("%s", "[Network] Request failed due to " + t);
                            ExcEventDispatch.fireEvent(new ExcEvent(ExcType.UKNOWN, //
                                    "[Network] Request failed due to " + t));
                        }
                    }
                }
            }
        }

        private boolean ensureConnected(ServerListManager serverMgr) throws InterruptedException {
            if (serverMgr.connectionProxy.isConnected())
                return true;
            log.info("[Global] Connecting to servers... " + serverMgr);
            return serverMgr.connectionProxy.connect();
            // Block until connected to server.
            //            while (!serverMgr.connectionProxy.connect()) {
            //                Thread.sleep(GLOBAL_RECONNECTING_DELAY);
            //            }
        }


        private void handleServerMessage(ProtocolPackage message) {
            for (ProtocolElement element : message) {
                try {
                    processorManager.processMessage(element, message);
                } catch (Exception e) {
                    log.warn("Exception in processing " + element.getClass().getName() + ": ", e);
                }
            }
        }
}
