
package com.taobao.config.client;

/**
 * 
 * @author caogu.wyp
 * 
 */
public class ConfigClientSetting {

    /** ַ*/
    private static String addressServerDomain = "jmenv.tbsite.net";
    private static String addressServerPort = "8080";

    /** Ż*/
    private volatile static boolean notCachePersist= false;
    private volatile static boolean timerCachePersist= false;
    private volatile static int persistBufferSize = 8192;
    private static int timerInitDelayMins = 30;
    private static int timerCycleMins = 60*24;
    private static long timerCycleTime = 0;
    private volatile static boolean notRollSnapshot  = false;

    static{

        String notCache = System.getProperty("configserver.client.nopersist");
        if(null != notCache && notCache.equals("true")){
            notCachePersist = true;
        }
        String timerPersist = System.getProperty("configserver.client.timerpersist");
        if(null != timerPersist && timerPersist.equals("true")){
            timerCachePersist = true;
        }
        String noroll = System.getProperty("configserver.client.norollsnapshot");
        if(null != noroll && noroll.equals("true")){
            notRollSnapshot = true;
        }
        Integer bufferSize = Integer.getInteger("configserver.client.persist.buffersize");
        if(null != bufferSize){
            persistBufferSize = bufferSize;
        }
        Integer initMins = Integer.getInteger("configserver.client.timerpersist.initMins");
        if(null != initMins){
            timerInitDelayMins = initMins;
        }
        Integer cycleMins = Integer.getInteger("configserver.client.timerpersist.cycleMins");
        if(null != cycleMins){
            timerCycleMins = cycleMins;
        }
        Long cycleTime = Long.getLong("configserver.client.timerpersist.cycleTime");
        if(null != cycleTime){
            timerCycleTime = cycleTime;
        }
    }

    public static void initSetting() {
        String domain = System.getProperty("address.server.domain");
        if (null != domain) {
            addressServerDomain = domain;
        }
        String port = System.getProperty("address.server.port");
        if (null != port) {
            addressServerPort = port;
        }

    }

    public static void setNotCachePersist(boolean notCachePersist) {
        ConfigClientSetting.notCachePersist = notCachePersist;
    }

    public static void setNotRollSnapshot(boolean notRollSnapshot) {
        ConfigClientSetting.notRollSnapshot = notRollSnapshot;
    }

    public static String getAddressServerDomain() {
        return addressServerDomain;
    }

    public static String getAddressServerPort() {
        return addressServerPort;
    }

    public static boolean isNotCachePersist() {
        return notCachePersist;
    }

    public static boolean isTimerCachePersist() {
        return timerCachePersist;
    }

    public static int getPersistBufferSize(){
        return persistBufferSize;
    }

    public static int getTimerInitDelayMins() {
        return timerInitDelayMins;
    }

    public static int getTimerCycleMins() {
        return timerCycleMins;
    }

    public static long getTimerCycleTime() {
        return timerCycleTime;
    }

    public static boolean isNotRollSnapshot() {
        return notRollSnapshot;
    }

}
