package com.taobao.config.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author wufeng
 *
 */
class ConfigClientRegistration {

    protected ConfigClientRegistration(final String clientName, final int instanceId) {
        if (clientName == null)
            throw new IllegalArgumentException("clientName is null");
        this.clientName = clientName;
        this.instanceId = instanceId;
    }

    // Attribute prefix "!" is reserved for internal attributes.
    public void setAttribute(final String attribute, final Serializable value) {
        if (value == null) {
            attributes.remove(attribute);
        } else {
            attributes.put(attribute, value);
        }
    }

    @SuppressWarnings("unchecked")
    public <V extends Serializable> V getAttribute(final String attribute) {
        return (V)attributes.get(attribute);
    }

    public String getStringAttribute(final String id) {
        final Object value = getAttribute(id);
        if (! (value instanceof String)) {
            return null;
        }
        return (String) value;
    }
    public Set<Map.Entry<String, Serializable>> getAllAttributes() {
        return attributes.entrySet();
    }

    public void setLocalAttribute(final String attribute, final Object value) {
        if (value == null) {
            localAttributes.remove(attribute);
        } else {
            localAttributes.put(attribute, value);
        }
    }

    @SuppressWarnings("unchecked")
    public <V> V getLocalAttribute(final String attribute) {
        return (V)localAttributes.get(attribute);
    }

    protected String getClientName() {
        return clientName;
    }
    protected String getClientId() {
        return clientName + "." + instanceId;
    }

    @Override
	public int hashCode() {
		final int prime = 31;
		int result = prime + clientName.hashCode();
		result = prime * result + attributes.hashCode();
		return prime * result + localAttributes.hashCode();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (! (obj instanceof ConfigClientRegistration))
			return false;
		final ConfigClientRegistration other = (ConfigClientRegistration) obj;
		if (! clientName.equals(other.clientName))
			return false;
		if (! attributes.equals(other.attributes))
			return false;
		if (! localAttributes.equals(other.localAttributes))
			return false;
		return true;
	}

	volatile boolean used;				// Flag to avoid duplicate register.
    private final String clientName;
    private final int instanceId;

    // Attributes that affects the reaction by server to client.
    private final Map<String, Serializable> attributes = new HashMap<String, Serializable>();
    // Local attributes will not be sent to server in register request, these are used for local functionalities.
    private final Map<String, Object> localAttributes = new HashMap<String, Object>();
}
