/**
 * Alipay.com Inc.
 * Copyright (c) 2004-2016 All Rights Reserved.
 */

package com.taobao.config.client;

import com.taobao.config.client.exception.ConfigClientException;
import com.taobao.middleware.logger.Logger;

/**
 * ConfigClientؼkeyĳȴС<br>
 * õȫԵ,Ӧÿ߲Ҫ
 * @author en.xuze@alipay.com
 * @version $Id: ConfigClientPerfCtrl.java, v 0.1 201678 10:19:51 en.xuze@alipay.com Exp $
 */
public class ConfigClientPerfCtrl {

    private static final Logger logger = ConfigClientLogger.getLogger(ConfigClientPerfCtrl.class);
    public static int dataIdLengthMax = 192;//dataIdĳ,Ŀǰͳ164
    public static int groupLengthMax = 32;//groupIdĳȣĿǰͳ16 ok
    public static int publisherNameLengthMax = 200;//publisherNameĳ
    public static int pubCountMax = 800;//ConfigClientֵ֧pub
    public static int maxPubCountPerConn = 400;//pub
    public static int maxSubCountPerConn = 1000;//Sub
    public static int dataContentLengthMax = 512;//dataIdĳ,hsfַĿǰһΪ166ңĿǰͳ696
    //Ƿö
    private static volatile boolean multiConnections = false;
    //ǷdumpPublisherSubscriber״̬
    private static boolean dumpServiceStatus = true;

    static {
        try {
            Integer SYSmaxPubCountPerConn = Integer.getInteger("CC.maxPubCountPerConn");
            if(SYSmaxPubCountPerConn!=null && SYSmaxPubCountPerConn != 0 ){
                maxPubCountPerConn = SYSmaxPubCountPerConn;
            }
            Integer SYSmaxSubCountPerConn = Integer.getInteger("CC.maxSubCountPerConn");
            if(SYSmaxSubCountPerConn!=null && SYSmaxSubCountPerConn != 0 ) {
                maxSubCountPerConn = SYSmaxSubCountPerConn;
            }
            Integer SYSpubCountMax = Integer.getInteger("CC.pubCountMax");
            if(SYSpubCountMax !=null && SYSpubCountMax != 0){
                pubCountMax = SYSpubCountMax;
            }
            Boolean SYSmultiConnections = Boolean.getBoolean("CC.multiConnections");
            if(SYSmultiConnections !=null && SYSmultiConnections.equals(Boolean.TRUE)) {
                SYSmultiConnections = Boolean.TRUE;
            }
        } catch (Exception e) {
            new ConfigClientException("Env-error", "configclient initial prefCtrl error, use default value, exception:").printStackTrace();
        }
    }

    /**
     * publisherName󳤶
     * @param publisherNameLengthMax
     */
    public static void setPublisherNameLengthMax(int publisherNameLengthMax) {
        logger.info("[set-max] publisherNameLengthMax to " + publisherNameLengthMax + ",default value is " + ConfigClientPerfCtrl.publisherNameLengthMax);
        ConfigClientPerfCtrl.publisherNameLengthMax = publisherNameLengthMax;
    }

    public static void setDataContentLengthMax(int dataContentLengthMax) {
        logger.info("[set-max] dataContentLengthMax to " + dataContentLengthMax + ",default value is " + ConfigClientPerfCtrl.dataContentLengthMax);
        ConfigClientPerfCtrl.dataContentLengthMax = dataContentLengthMax;
    }

    /**
     * dataId󳤶
     * 
     * @param dataIdLengthMax
     */
    public static void setDataIdLengthMax(int dataIdLengthMax) {
        logger.info("[set-max] dataIdLengthMax to " + dataIdLengthMax + ",default value is " + ConfigClientPerfCtrl.dataIdLengthMax);
        ConfigClientPerfCtrl.dataIdLengthMax = dataIdLengthMax;
    }

    /**
     * group󳤶
     * 
     * @param groupLengthMax
     */
    public static void setGroupLengthMax(int groupLengthMax) {
        logger.info("[set-max] groupLengthMax to " + groupLengthMax + ",default value is " + ConfigClientPerfCtrl.groupLengthMax);
        ConfigClientPerfCtrl.groupLengthMax = groupLengthMax;
    }

    /**
     * ֵ֧Publisher 
     * @param pubCountMax
     */
    public static void setPubCountMax(int pubCountMax) {
        logger.info("[set-max] pubCountMax to " + pubCountMax + ",default value is " + ConfigClientPerfCtrl.pubCountMax);
        ConfigClientPerfCtrl.pubCountMax = pubCountMax;
    }

    public static void openMultiConnections() {
        logger.info("[set-multi-connections] set multiConnections true");
        ConfigClientPerfCtrl.multiConnections = true;
    }

    public static void setDumpServiceStatus(boolean value) {
        logger.info("[set-dump-service-status] set dumpServiceStatus to " + value);
        ConfigClientPerfCtrl.dumpServiceStatus = value;
    }

    public static void setMaxPubCountPerConn(int maxPubCountPerConn) {
        logger.info("[set-max-pub-count-per-conn] set maxPubCountPerConn to " + maxPubCountPerConn);
        ConfigClientPerfCtrl.maxPubCountPerConn = maxPubCountPerConn;
    }

    public static boolean isMultiConnections() {
        return multiConnections;
    }

    public static boolean isDumpServiceStatus() {
        return dumpServiceStatus;
    }

    public static void main(String[] args) {
        ConfigClientPerfCtrl.setPubCountMax(Integer.MAX_VALUE);//pub޵ĹܣĬϵip800pub
        ConfigClientPerfCtrl.openMultiConnections();//򿪴ӵĹ
        ConfigClientPerfCtrl.setMaxPubCountPerConn(10);//õϿԷpub
    }
}
