package com.taobao.config.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import com.taobao.middleware.logger.Logger;



/**
 * @author JIUREN
 */
final class ConfigClientNotifier {

	static void notify(DefaultSubscriber subscriber) {
	    notifierThread.queue.offer(subscriber);
	}

    static final NotifierThread notifierThread;
    static {
        notifierThread = new NotifierThread();
        notifierThread.start();
    }
}

class NotifierThread extends Thread {

    NotifierThread() {
        super("ConfigClientNotifier");
        setDaemon(true);
    }

    @Override
    public void run() {
        log.info("[Notifier] Notifier thread is starting...");
        
        for (;;) {
            try {
                DefaultSubscriber subscriber = getNotifyTask();
                
                subscriber.signalObservers();
                
            } catch (Throwable t) {
                log.error("%s","[Global] Unexpected exception in NotifierThread: ", t);
                try {
                    Thread.sleep(1000L);
                } catch (InterruptedException e) {
                }
            }
        }
    }
    
    DefaultSubscriber getNotifyTask() throws InterruptedException {
        DefaultSubscriber subscriber = queue.take();
        while (queue.remove(subscriber)) {} // ϲ֪ͨ
        return subscriber;
    }
    
    static final Logger log = ConfigClientLogger.getLogger(ConfigClientNotifier.class);
    static final int MAX_OBSERVER_TIME_CONSUMING = 5000;
    
    final BlockingQueue<DefaultSubscriber> queue = new LinkedBlockingQueue<DefaultSubscriber>();
}
