
package com.taobao.config.client;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

import com.taobao.config.client.bean.ObserverData;
import com.taobao.config.client.utils.IOUtils;
import com.taobao.config.client.utils.JSONUtils;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.config.common.protocol.utils.TransmitUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.util.LogConstants;

/**
 * дcachecacheȡݡ JSONı
 */
final public class CachePersist {

    /**
     * ȡóʼݡµcacheļݡNULLʾûгʼݡ
     */
    static public List<Object> initialData(String dataId, String groupId, String tenant, String env) {
        groupId = defaultIfNull(groupId);
        tenant = (null != tenant) ? tenant : LocalConfigInfo.DEFAULT_TENANT;
        File lastCache = latestSnapshot(dataId, groupId, tenant, env, false);
        return null != lastCache ? parse(lastCache) : null;
    }

    static public List<Object> initialData(String dataId, String groupId, String env) {
        return initialData(dataId, groupId, null, env);
    }

    static public Map<String, List<ObserverData>> initialDataWithMeta(String dataId, String groupId, String env) {
        return initialDataWithMeta(dataId, groupId, null, env);
    }

    static public Map<String, List<ObserverData>> initialDataWithMeta(String dataId, String groupId, String tenant, String env) {
        groupId = defaultIfNull(groupId);
        tenant = (null != tenant) ? tenant : LocalConfigInfo.DEFAULT_TENANT;
        File lastCache = latestSnapshot(dataId, groupId, tenant, env, true);
        return null != lastCache ? parseDataWithMeta(lastCache) : null;
    }

    /**
     * ļNULLʾûļ㳤бʾݣûݡ
     */
    static public List<Object> parse(File dataFile) {
        if (!dataFile.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(dataFile);
            String jsonText = IOUtils.toString(fin, "GBK");
            if (StringUtils.EMPTY.equals(jsonText)) { // GSONѿбתΪ[]
                return Collections.emptyList();
            } else {
                return TransmitUtils.fromJSON(jsonText);
            }
        } catch (Exception e) {
            log.error("%s", "error when read file: " + dataFile.getAbsolutePath() + ", " + e.toString(), e);
            return null;
        } finally {
            if (null != fin) {
                try {
                    fin.close();
                } catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
        }
    }

    /**
     * ļNULLʾûļ㳤бʾݣûݡ
     */
    static public Map<String, List<ObserverData>> parseDataWithMeta(File dataFile) {
        if (!dataFile.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(dataFile);
            String jsonText = IOUtils.toString(fin, "GBK");
            if (StringUtils.EMPTY.equals(jsonText)) { // GSONѿбתΪ[]
                return Collections.emptyMap();
            } else {
                return JSONUtils.dataWithMetafromJSON(jsonText);
            }
        } catch (Exception e) {
            log.error("%s", "error when read file: " + dataFile.getAbsolutePath() + ", " + e.toString(), e);
            return null;
        } finally {
            if (null != fin) {
                try {
                    fin.close();
                } catch (Exception e) {
                    log.error("%s", e.toString(), e);
                }
            }
        }
    }

    static public String defaultIfNull(String group) {
        return (null != group) ? group : "DEFAULT_GROUP";
    }

    public static void save(String dataId, String groupId, List datas, String env) {
        save(dataId, groupId, LocalConfigInfo.DEFAULT_TENANT, datas, env);
    }
    public static void save(String dataId, String groupId, List datas) {
        save(dataId, groupId, LocalConfigInfo.DEFAULT_TENANT, datas, LocalConfigInfo.DEFAULT_ENV);
    }

//    public static void saveWithMeta(String dataId, String groupId, List<ObserverData> datas){
//        save();
//    }

    /**
     * snapshotݡ
     */
    @SuppressWarnings("rawtypes")
    public static void save(String dataId, String groupId, String tenant, List datas, String env) {

        groupId = defaultIfNull(groupId);
        tenant = (null != tenant) ? tenant : "DEFAULT_TENANT";
        String jsonText = TransmitUtils.toJSON(datas);
        log.info(LogConstants.PREFIX_IMPORTANT + "[snapshot-save] " + LocalConfigInfo.SNAPSHOT_ROOT + File.separator + dataId + ", " + groupId + ", " + tenant);
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            } catch (Exception e) {
                log.error("%s", "Error while encoding file name: " + dataId, e);
            }
        }
        String dataFileStr = MessageFormat.format(LocalConfigInfo.DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
        File dataFile = new File(dataFileStr);
        Writer fout = null;
        try {
            dataFile.getParentFile().mkdirs();
            dataFile.createNewFile();
            fout = new OutputStreamWriter(new FileOutputStream(dataFile), "GBK");
            fout.write(jsonText);
        } catch (IOException e) {
            log.error("%s", e.toString(), e);
        } finally {
            if (null != fout) {
                try {
                    fout.close();
                } catch (Exception e2) {
                    log.error("%s", e2.toString(), e2);
                }
            }
        }
    }

    public static void save(String dataId, String groupId, String tenant, Map<String, List<ObserverData>> dataGroup, String env) {
        groupId = defaultIfNull(groupId);
        tenant = (null != tenant) ? tenant : "DEFAULT_TENANT";
        log.info(LogConstants.PREFIX_IMPORTANT + "[snapshot-save] " + LocalConfigInfo.SNAPSHOT_ROOT + File.separator + dataId + ", " + groupId + ", " + tenant);
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            } catch (Exception e) {
                log.error("%s", "Error while encoding file name: " + dataId, e);
            }
        }
        String dataFileStr = MessageFormat.format(LocalConfigInfo.META_DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
        File dataFile = new File(dataFileStr);
        BufferedWriter bufferedWriter = null;
        try {
            dataFile.getParentFile().mkdirs();
            dataFile.createNewFile();

            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile), "GBK"), ConfigClientSetting.getPersistBufferSize());
            if (dataGroup == null || dataGroup.isEmpty()) {
                bufferedWriter.write("\"\"");
                return;
            }
            bufferedWriter.write("{");
            int entryIndex = 0;
            for (Map.Entry<String, List<ObserverData>> entry : dataGroup.entrySet()) {
                String key = entry.getKey();
                bufferedWriter.write("\"");
                bufferedWriter.write(key);
                bufferedWriter.write("\":[\r\n");
                List<ObserverData> obDatas = entry.getValue();
                if (obDatas != null) {
                    for (int i = 0; i < obDatas.size(); i++) {
                        ObserverData observerData = obDatas.get(i);
                        bufferedWriter.write("{");
                        if (observerData.getAppName() != null) {
                            bufferedWriter.write("\"appName\":\"");
                            bufferedWriter.write(observerData.getAppName());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getMachineGroup() != null) {
                            bufferedWriter.write("\"machineGroup\":\"");
                            bufferedWriter.write(observerData.getMachineGroup());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getUnit() != null) {
                            bufferedWriter.write("\"unit\":\"");
                            bufferedWriter.write(observerData.getUnit());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getSite() != null) {
                            bufferedWriter.write("\"site\":\"");
                            bufferedWriter.write(observerData.getSite());
                            bufferedWriter.write("\",");
                        }
                        if (observerData.getIpGroup() != null) {
                            bufferedWriter.write("\"ipGroup\":\"");
                            bufferedWriter.write(observerData.getIpGroup());
                            bufferedWriter.write("\",\r\n");
                        }
                        bufferedWriter.write("\"data\":\"");
                        bufferedWriter.write((String) observerData.getData());
                        if (i != (obDatas.size() - 1)) {
                            bufferedWriter.write("\"},\r\n");
                        } else {
                            bufferedWriter.write("\"}\r\n");
                        }
                    }
                }
                if (entryIndex != (dataGroup.size() - 1)) {
                    bufferedWriter.write("],\r\n");
                } else {
                    bufferedWriter.write("]\r\n");
                }
                entryIndex++;
            }
            bufferedWriter.write("}");
        } catch (IOException e) {
            log.error("%s", e.toString(), e);
        } finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                } catch (Exception e2) {
                    log.error("%s", e2.toString(), e2);
                }
            }
        }
    }
    static public List<File> getSnapshots(String dataId, final String groupId) {
        return getSnapshots(dataId, groupId, LocalConfigInfo.DEFAULT_ENV, false);
    }

    static public List<File> getSnapshots(String dataId, String groupId, String env, boolean isMetaData) {
        return getSnapshots(dataId, groupId,LocalConfigInfo.DEFAULT_TENANT, env, isMetaData);
    }

        /**
         * ָdataIdgroupIdҵеsnapshotļ
         *
         * @return ᷵NULL.
         */
    static public List<File> getSnapshots(String dataId, final String groupId, final String tenant, String env, final String fileEnd) {
        if (LocalConfigInfo.IsWindows) {
            try {
                dataId = URLEncoder.encode(dataId, "GBK");
            } catch (Exception e) {
                log.error("%s", "Error while decoding file name: " + dataId, e);
            }
        }
        File dataIdDir = new File(LocalConfigInfo.SNAPSHOT_ROOT + File.separator + env.replaceAll("\\?", "#"), dataId);
        File[] snapshots = dataIdDir.listFiles(new FileFilter() {

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(groupId + "-" + tenant + fileEnd);
            }
        });
        return null == snapshots ? Collections.<File>emptyList() //
                : new ArrayList<File>(Arrays.asList(snapshots));
    }

    static public List<File> getSnapshots(String dataId, final String groupId, final String tenant, String env, boolean isMetaData) {
        final String fileEnd = isMetaData?"-withMeta.dat":".dat";
        return getSnapshots(dataId, groupId, tenant, env, fileEnd);
    }

    /**
     * ҵµsnapshotļ
     */
    static public File latestSnapshot(String dataId, String groupId) {
        return latestSnapshot(dataId, groupId, LocalConfigInfo.DEFAULT_TENANT, LocalConfigInfo.DEFAULT_ENV, false);
    }
    /**
     * ҵµsnapshotļ
     */
    static public File latestSnapshot(String dataId, String groupId, boolean isMetaData) {
        return latestSnapshot(dataId, groupId, LocalConfigInfo.DEFAULT_TENANT, LocalConfigInfo.DEFAULT_ENV, isMetaData);
    }
    /**
     * ҵµsnapshotļ
     */
    static public File latestSnapshot(String dataId, String groupId, String env, boolean isMetaData) {
        return latestSnapshot(dataId, groupId, LocalConfigInfo.DEFAULT_TENANT, env, isMetaData);
    }
    /**
     * ҵµsnapshotļ
     */
    static public File latestSnapshot(String dataId, String groupId, String tenant, String env, final String fileEnd) {
        List<File> snapshots = CachePersist.getSnapshots(dataId, groupId, tenant, env, fileEnd);
        if (snapshots.isEmpty()) {
            return null;
        }
        // select the latest snapshot
        long latestTime = -1;
        File latestSnapshot = null;
        for (File snapshot : snapshots) {
            long time = snapshot.lastModified();
            if (time > latestTime) {
                latestTime = time;
                latestSnapshot = snapshot;
            }
        }
        return latestSnapshot;
    }

    static public File latestSnapshot(String dataId, String groupId, String tenant, String env, boolean isMetaData) {
        final String fileEnd = isMetaData?"-withMeta.dat":".dat";
        return latestSnapshot(dataId, groupId, tenant, env, fileEnd);
    }

    static public boolean isNewSnapshots(String dataId, String groupId, String tenant, String env){
        File file = latestSnapshot(dataId, groupId, tenant, env,"");
        String name = file.getName();
        return name.endsWith("-withMeta.dat");
    }
    /**
     * ȫcacheļ!!!
     */
    static void clear() {
        File root = new File(LocalConfigInfo.SNAPSHOT_ROOT);
        File[] sub = root.listFiles();
        if (null == sub) {
            return;
        }
        for (File dataIdDir : sub) {
            if (dataIdDir.isDirectory()) {
                for (File dataFile : dataIdDir.listFiles()) {
                    dataFile.delete();
                }
                dataIdDir.delete();
            }
        }
    }
    // ====================

    static private final Logger log = ConfigClientLogger.getLogger(CachePersist.class);
    static {
        // ڶ賿ִ 03:[0~59]:00
        if(!ConfigClientSetting.isNotRollSnapshot()) {
            Calendar now = Calendar.getInstance();
            Calendar next = Calendar.getInstance();
            next.set(Calendar.HOUR_OF_DAY, 3);
            Random random = new Random();
            int randomMins = random.nextInt(60);
            next.set(Calendar.MINUTE, randomMins);
            next.set(Calendar.SECOND, 0);
            next.roll(Calendar.DATE, 1);
            log.info("[RollSnapshot-init] 03:"+randomMins);
            long delayMs = next.getTimeInMillis() - now.getTimeInMillis();
            ConfigClientTimerService.timer.scheduleAtFixedRate(new RollSnapshotTask(), delayMs, TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
        }
        if(ConfigClientSetting.isTimerCachePersist()) {
            ConfigClientTimerService.timer.scheduleWithFixedDelay(new TimerCachePersistTask(),
                    ConfigClientSetting.getTimerInitDelayMins(), ConfigClientSetting.getTimerCycleMins(), TimeUnit.MINUTES);
        }
    }

    // ====================
    /**
     * ÿ賿лsnapshotļ
     */
    static class TimerCachePersistTask implements Runnable {

        @Override
        public void run() {
            if(ConfigClientSetting.isNotCachePersist()){
                log.info("[timer-cache-persist] isNotCachePersist is true, timer-cache not start");
                return;
            }
            log.info("[timer-cache-persist] persist start");
            long startTime = System.currentTimeMillis();
            for (Subscriber sub : SubscriberRegistrar.getSubs()) {

                String dataId = sub.getRegistration().getDataId();
                String groupId = sub.getRegistration().getGroup();
                String tenant = sub.getRegistration().getTenant();
                String env = "";
                Map<String, List<ObserverData>> dataMap = null;
                try {
                    if (sub instanceof DefaultSubscriber) {
                        DefaultSubscriber defaultSubscriber = ((DefaultSubscriber) sub);
                        env = defaultSubscriber.serverMgr.getEnv();
                        dataMap = defaultSubscriber.getObserverDataGroups();
                    }
                    if (dataMap != null) {
                        CachePersist.save(dataId, groupId, tenant, dataMap, env);
                    }
                    if(ConfigClientSetting.getTimerCycleTime()!=0){
                        Thread.sleep(ConfigClientSetting.getTimerCycleTime());
                    }
                } catch (Exception ioe) {
                    log.error("%s", "[timer-snapshot] fail to cache. dataId: " + dataId + ", groupId: " + groupId, ioe);
                }
            }
            log.info("[timer-cache-persist] persist end, time is "+(System.currentTimeMillis()-startTime)+"ms");
        }
    }


        // ====================
    /**
     * ÿ賿лsnapshotļ
     */
    static class RollSnapshotTask implements Runnable {

        @Override
        public void run() {
            if(ConfigClientSetting.isNotRollSnapshot()){
                return;
            }
            for (Subscriber sub : SubscriberRegistrar.getSubs()) {
                String dataId = sub.getRegistration().getDataId();
                String groupId = sub.getRegistration().getGroup();
                //TODO
                String tenant = sub.getRegistration().getTenant();
                String env = "";
                if (sub instanceof DefaultSubscriber) {
                    env = ((DefaultSubscriber) sub).serverMgr.getEnv();
                }
                boolean isExistSubMetaDataObserver = ((DefaultSubscriber) sub).isExistSubMetaDataObserver;
                String snapshotPath = null;
                try {
                    boolean isNew = isNewSnapshots(dataId, groupId, tenant, env);
                    if(isNew){
                        snapshotPath = MessageFormat.format(LocalConfigInfo.META_DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
                    } else {
                        snapshotPath = MessageFormat.format(LocalConfigInfo.DATA_FILE_PATTERN, env.replaceAll("\\?", "#"), dataId, groupId, tenant);
                    }
                    String renamePath = snapshotPath + "." + calculateSuffix();
                    File snapshotFile = new File(snapshotPath);
                    snapshotFile.renameTo(new File(renamePath));
                    IOUtils.copyFile(renamePath, snapshotPath);

                    keepLatest8(dataId, groupId, tenant, env, null);
                } catch (Exception ioe) {
                    log.error("%s", "[roll-snapshot] fail to roll. dataId: " + dataId + ", groupId: " + groupId, ioe);
                }
            }
        }

        /**
         *
         * @param dataId
         * @param groupId
         * @param tenant
         * @param env
         * @param isMetaData ΪnullΪȫҪ
         */
        static void keepLatest8(String dataId, final String groupId, final String tenant, final String env, final Boolean isMetaData) {
            List<File> snapshots = null;
            if(isMetaData==null){
                /** õϵĻ棬߼ 汾ȥ*/
                snapshots = getSnapshots(dataId, groupId, tenant, env, false);
                /** µĻ*/
                snapshots.addAll(getSnapshots(dataId, groupId, tenant, env, true));
            }else{
                snapshots = getSnapshots(dataId, groupId, tenant, env, isMetaData);
            }
            final int count = 8;
            if (snapshots.size() <= count) {
                return;
            }
            Collections.sort(snapshots, new Comparator<File>() {

                @Override
                public int compare(File o1, File o2) {
                    return (int) Math.signum(o1.lastModified() - o2.lastModified());
                }
            });
            while (snapshots.size() > count) {
                snapshots.remove(0).delete();
            }
        }

        /**
         * õǰʱΪsnapshotļĺ׺
         */
        static String calculateSuffix() {
            SimpleDateFormat fileSuffix = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            return fileSuffix.format(new Date());
        }
    }
}
