/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.CalendarUtils;
import org.apache.commons.lang3.time.DatePrinter;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final Rule[] EMPTY_RULE_ARRAY = new Rule[0];
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<TimeZoneDisplayKey, String>(7);
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private transient Rule[] rules;
    private transient int maxLengthEstimate;

    /*
     * WARNING - void declaration
     */
    private static void appendDigits(Appendable buffer, int value) throws IOException {
        void var1_1;
        Appendable appendable;
        buffer.append((char)(value / 10 + 48));
        appendable.append((char)(var1_1 % 10 + 48));
    }

    private static void appendFullDigits(Appendable buffer, int value, int minFieldWidth) throws IOException {
        if (value < 10000) {
            int nDigits = 4;
            if (value < 1000) {
                --nDigits;
                if (value < 100) {
                    --nDigits;
                    if (value < 10) {
                        --nDigits;
                    }
                }
            }
            for (int i2 = minFieldWidth - nDigits; i2 > 0; --i2) {
                buffer.append('0');
            }
            switch (nDigits) {
                case 4: {
                    buffer.append((char)(value / 1000 + 48));
                    value %= 1000;
                }
                case 3: {
                    if (value >= 100) {
                        buffer.append((char)(value / 100 + 48));
                        value %= 100;
                    } else {
                        buffer.append('0');
                    }
                }
                case 2: {
                    if (value >= 10) {
                        buffer.append((char)(value / 10 + 48));
                        value %= 10;
                    } else {
                        buffer.append('0');
                    }
                }
                case 1: {
                    buffer.append((char)(value + 48));
                }
            }
            return;
        }
        char[] work = new char[10];
        int digit = 0;
        while (value != 0) {
            work[digit++] = (char)(value % 10 + 48);
            value /= 10;
        }
        while (digit < minFieldWidth) {
            buffer.append('0');
            --minFieldWidth;
        }
        while (--digit >= 0) {
            buffer.append(work[digit]);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String getTimeZoneDisplay(TimeZone tz, boolean daylight, int style, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        TimeZone timeZone;
        TimeZoneDisplayKey key = new TimeZoneDisplayKey(tz, daylight, style, locale);
        return cTimeZoneDisplayCache.computeIfAbsent(key, arg_0 -> FastDatePrinter.lambda$getTimeZoneDisplay$0(timeZone, (boolean)var1_1, (int)var2_2, (Locale)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    protected FastDatePrinter(String pattern, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.pattern = var1_1;
        this.timeZone = var2_2;
        this.locale = LocaleUtils.toLocale((Locale)var3_3);
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private <B extends Appendable> B applyRules(Calendar calendar, B buf) {
        void var2_2;
        try {
            Rule[] ruleArray = this.rules;
            int n2 = this.rules.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Rule rule = ruleArray[i2];
                rule.appendTo(buf, calendar);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            ExceptionUtils.asRuntimeException(iOException);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer buf) {
        void var2_2;
        void var1_1;
        return (StringBuffer)this.applyRules((Calendar)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String applyRulesToString(Calendar c2) {
        void var1_1;
        return this.applyRules((Calendar)var1_1, new StringBuilder(this.maxLengthEstimate)).toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter other = (FastDatePrinter)obj;
        return this.pattern.equals(other.pattern) && this.timeZone.equals(other.timeZone) && this.locale.equals(var1_1.locale);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(Calendar calendar) {
        void var1_1;
        return this.format((Calendar)var1_1, new StringBuilder(this.maxLengthEstimate)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        void var2_2;
        void var1_1;
        if (!calendar.getTimeZone().equals(this.timeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.timeZone);
        }
        return this.applyRules((Calendar)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuffer format(Calendar calendar, StringBuffer buf) {
        void var2_2;
        void var1_1;
        return this.format(var1_1.getTime(), (StringBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(Date date) {
        void var2_2;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTime((Date)var1_1);
        return this.applyRulesToString((Calendar)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        void var2_2;
        void var3_3;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTime((Date)var1_1);
        return this.applyRules((Calendar)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuffer format(Date date, StringBuffer buf) {
        void var2_2;
        void var3_3;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTime((Date)var1_1);
        return (StringBuffer)this.applyRules((Calendar)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String format(long millis) {
        void var3_2;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTimeInMillis((long)var1_1);
        return this.applyRulesToString((Calendar)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        void var3_2;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTimeInMillis((long)var1_1);
        return this.applyRules(c2, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuffer format(long millis, StringBuffer buf) {
        void var3_2;
        void var1_1;
        Calendar c2 = this.newCalendar();
        c2.setTimeInMillis((long)var1_1);
        return (StringBuffer)this.applyRules(c2, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    String format(Object obj) {
        void var1_1;
        if (obj instanceof Date) {
            return this.format((Date)obj);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj);
        }
        if (obj instanceof Long) {
            return this.format((Long)obj);
        }
        throw new IllegalArgumentException("Unknown class: " + ClassUtils.getName(var1_1, "<null>"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        void var1_1;
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo);
        }
        if (obj instanceof Long) {
            void var2_2;
            return this.format((long)((Long)obj), (StringBuffer)var2_2);
        }
        throw new IllegalArgumentException("Unknown class: " + ClassUtils.getName(var1_1, "<null>"));
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxLengthEstimate() {
        return this.maxLengthEstimate;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var1_2;
        List<Rule> rulesList = this.parsePattern();
        this.rules = rulesList.toArray(EMPTY_RULE_ARRAY);
        int len = 0;
        int i2 = this.rules.length;
        while (--i2 >= 0) {
            len += this.rules[i2].estimateLength();
        }
        this.maxLengthEstimate = var1_2;
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.timeZone, this.locale);
    }

    /*
     * WARNING - void declaration
     */
    protected List<Rule> parsePattern() {
        void var2_2;
        DateFormatSymbols symbols = new DateFormatSymbols(this.locale);
        ArrayList<Iso8601_Rule> rules = new ArrayList<Iso8601_Rule>();
        String[] ERAs = symbols.getEras();
        String[] months = symbols.getMonths();
        String[] shortMonths = symbols.getShortMonths();
        String[] weekdays = symbols.getWeekdays();
        String[] shortWeekdays = symbols.getShortWeekdays();
        String[] AmPmStrings = symbols.getAmPmStrings();
        int length = this.pattern.length();
        int[] indexRef = new int[1];
        for (int i2 = 0; i2 < length; ++i2) {
            Rule rule;
            indexRef[0] = i2;
            FastDatePrinter fastDatePrinter = this;
            String token = fastDatePrinter.parseToken(fastDatePrinter.pattern, indexRef);
            i2 = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c2 = token.charAt(0);
            switch (c2) {
                case 'G': {
                    rule = new TextField(0, ERAs);
                    break;
                }
                case 'Y': 
                case 'y': {
                    rule = tokenLen == 2 ? TwoDigitYearField.INSTANCE : this.selectNumberRule(1, Math.max(tokenLen, 4));
                    if (c2 != 'Y') break;
                    rule = new WeekYear((NumberRule)rule);
                    break;
                }
                case 'M': {
                    if (tokenLen >= 4) {
                        rule = new TextField(2, months);
                        break;
                    }
                    if (tokenLen == 3) {
                        rule = new TextField(2, shortMonths);
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'L': {
                    if (tokenLen >= 4) {
                        rule = new TextField(2, CalendarUtils.getInstance(this.locale).getStandaloneLongMonthNames());
                        break;
                    }
                    if (tokenLen == 3) {
                        rule = new TextField(2, CalendarUtils.getInstance(this.locale).getStandaloneShortMonthNames());
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, tokenLen);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(this.selectNumberRule(10, tokenLen));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, tokenLen);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, tokenLen);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, tokenLen);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, tokenLen);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, tokenLen < 4 ? shortWeekdays : weekdays);
                    break;
                }
                case 'u': {
                    rule = new DayInWeekField(this.selectNumberRule(7, tokenLen));
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, tokenLen);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, tokenLen);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, tokenLen);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, tokenLen);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, AmPmStrings);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(this.selectNumberRule(11, tokenLen));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, tokenLen);
                    break;
                }
                case 'X': {
                    rule = Iso8601_Rule.getRule(tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        rule = new TimeZoneNameRule(this.timeZone, this.locale, 1);
                        break;
                    }
                    rule = new TimeZoneNameRule(this.timeZone, this.locale, 0);
                    break;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        rule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    rule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String sub = ((String)((Object)rule)).substring(1);
                    if (sub.length() == 1) {
                        rule = new CharacterLiteral(sub.charAt(0));
                        break;
                    }
                    rule = new StringLiteral((String)((Object)rule));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + (String)((Object)rule));
                }
            }
            rules.add((Iso8601_Rule)rule);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String parseToken(String pattern, int[] indexRef) {
        void var3_3;
        int i2;
        StringBuilder buf = new StringBuilder();
        int length = pattern.length();
        char c2 = pattern.charAt(i2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            buf.append(c2);
            while (i2 + 1 < length && (c3 = pattern.charAt(i2 + 1)) == c2) {
                buf.append(c2);
                ++i2;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i2 = indexRef[0]; i2 < length; ++i2) {
                c2 = pattern.charAt(i2);
                if (c2 == '\'') {
                    if (i2 + 1 < length && pattern.charAt(i2 + 1) == '\'') {
                        ++i2;
                        buf.append(c2);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    buf.append(c2);
                    continue;
                }
                break;
            }
        }
        var2_2[0] = --i2;
        return var3_3.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    protected NumberRule selectNumberRule(int field, int padding) {
        void var2_2;
        void var1_1;
        switch (padding) {
            case 1: {
                return new UnpaddedNumberField(field);
            }
            case 2: {
                return new TwoDigitNumberField(field);
            }
        }
        return new PaddedNumberField((int)var1_1, (int)var2_2);
    }

    public String toString() {
        return "FastDatePrinter[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$getTimeZoneDisplay$0(TimeZone tz, boolean daylight, int style, Locale locale, TimeZoneDisplayKey k2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return tz.getDisplayName((boolean)var1_1, (int)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Appendable x0, int x1) throws IOException {
        void var1_1;
        FastDatePrinter.appendDigits(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Appendable x0, int x1, int x2) throws IOException {
        void var2_2;
        void var1_1;
        FastDatePrinter.appendFullDigits(x0, (int)var1_1, (int)var2_2);
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone timeZone;
        private final int style;
        private final Locale locale;

        /*
         * WARNING - void declaration
         */
        TimeZoneDisplayKey(TimeZone timeZone, boolean daylight, int style, Locale locale) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.timeZone = var1_1;
            this.style = var2_2 != false ? style | Integer.MIN_VALUE : var3_3;
            this.locale = LocaleUtils.toLocale(locale);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TimeZoneDisplayKey) {
                void var1_1;
                TimeZoneDisplayKey other = (TimeZoneDisplayKey)obj;
                return this.timeZone.equals(other.timeZone) && this.style == other.style && this.locale.equals(var1_1.locale);
            }
            return false;
        }

        public int hashCode() {
            return (this.style * 31 + this.locale.hashCode()) * 31 + this.timeZone.hashCode();
        }
    }

    private static interface Rule {
        public void appendTo(Appendable var1, Calendar var2) throws IOException;

        public int estimateLength();
    }

    private static class TextField
    implements Rule {
        private final int field;
        private final String[] values;

        /*
         * WARNING - void declaration
         */
        TextField(int field, String[] values2) {
            void var2_2;
            void var1_1;
            this.field = var1_1;
            this.values = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            buffer.append(this.values[var2_2.get(this.field)]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int estimateLength() {
            void var1_1;
            int max = 0;
            int i2 = this.values.length;
            while (--i2 >= 0) {
                void var3_3;
                int len = this.values[i2].length();
                if (len <= max) continue;
                max = var3_3;
            }
            return (int)var1_1;
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(1) % 100);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$000(buffer, (int)(var2_2 % 100));
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(Appendable var1, int var2) throws IOException;
    }

    private static class WeekYear
    implements NumberRule {
        private final NumberRule rule;

        /*
         * WARNING - void declaration
         */
        WeekYear(NumberRule rule) {
            void var1_1;
            this.rule = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.rule.appendTo((Appendable)var1_1, var2_2.getWeekYear());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.rule.appendTo((Appendable)var1_1, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(2) + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$000(buffer, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(2) + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule rule;

        /*
         * WARNING - void declaration
         */
        TwelveHourField(NumberRule rule) {
            void var1_1;
            this.rule = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var3_3;
            void var1_1;
            int value = calendar.get(10);
            if (value == 0) {
                void var2_2;
                value = var2_2.getLeastMaximum(10) + 1;
            }
            this.rule.appendTo((Appendable)var1_1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.rule.appendTo((Appendable)var1_1, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class DayInWeekField
    implements NumberRule {
        private final NumberRule rule;

        /*
         * WARNING - void declaration
         */
        DayInWeekField(NumberRule rule) {
            void var1_1;
            this.rule = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            int value = calendar.get(7);
            this.rule.appendTo((Appendable)var1_1, value == 1 ? 7 : var2_3 - true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.rule.appendTo((Appendable)var1_1, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule rule;

        /*
         * WARNING - void declaration
         */
        TwentyFourHourField(NumberRule rule) {
            void var1_1;
            this.rule = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var3_3;
            void var1_1;
            int value = calendar.get(11);
            if (value == 0) {
                void var2_2;
                value = var2_2.getMaximum(11) + 1;
            }
            this.rule.appendTo((Appendable)var1_1, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.rule.appendTo((Appendable)var1_1, (int)var2_2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class Iso8601_Rule
    implements Rule {
        static final Iso8601_Rule ISO8601_HOURS = new Iso8601_Rule(3);
        static final Iso8601_Rule ISO8601_HOURS_MINUTES = new Iso8601_Rule(5);
        static final Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new Iso8601_Rule(6);
        private final int length;

        static Iso8601_Rule getRule(int tokenLen) {
            switch (tokenLen) {
                case 1: {
                    return ISO8601_HOURS;
                }
                case 2: {
                    return ISO8601_HOURS_MINUTES;
                }
                case 3: {
                    return ISO8601_HOURS_COLON_MINUTES;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }

        /*
         * WARNING - void declaration
         */
        Iso8601_Rule(int length) {
            void var1_1;
            this.length = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            void var3_4;
            int offset = calendar.get(15) + calendar.get(16);
            if (offset == 0) {
                buffer.append("Z");
                return;
            }
            if (offset < 0) {
                buffer.append('-');
                offset = -offset;
            } else {
                buffer.append('+');
            }
            int hours = offset / 3600000;
            FastDatePrinter.access$000(buffer, hours);
            if (this.length < 5) {
                return;
            }
            if (this.length == 6) {
                buffer.append(':');
            }
            int minutes = offset / 60000 - var3_4 * 60;
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_3);
        }

        @Override
        public int estimateLength() {
            return this.length;
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final Locale locale;
        private final int style;
        private final String standard;
        private final String daylight;

        /*
         * WARNING - void declaration
         */
        TimeZoneNameRule(TimeZone timeZone, Locale locale, int style) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.locale = LocaleUtils.toLocale(locale);
            this.style = style;
            this.standard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, style, locale);
            this.daylight = FastDatePrinter.getTimeZoneDisplay((TimeZone)var1_1, true, (int)var3_3, (Locale)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var3_4;
            void var1_1;
            TimeZone zone = calendar.getTimeZone();
            boolean daylight = calendar.get(16) != 0;
            var1_1.append(FastDatePrinter.getTimeZoneDisplay((TimeZone)var3_4, (boolean)var2_3, this.style, this.locale));
        }

        @Override
        public int estimateLength() {
            return Math.max(this.standard.length(), this.daylight.length());
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        private final boolean colon;

        /*
         * WARNING - void declaration
         */
        TimeZoneNumberRule(boolean colon) {
            void var1_1;
            this.colon = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_3;
            void var1_1;
            void var3_4;
            int offset = calendar.get(15) + calendar.get(16);
            if (offset < 0) {
                buffer.append('-');
                offset = -offset;
            } else {
                buffer.append('+');
            }
            int hours = offset / 3600000;
            FastDatePrinter.access$000(buffer, hours);
            if (this.colon) {
                buffer.append(':');
            }
            int minutes = offset / 60000 - var3_4 * 60;
            FastDatePrinter.access$000((Appendable)var1_1, (int)var2_3);
        }

        @Override
        public int estimateLength() {
            return 5;
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char value;

        /*
         * WARNING - void declaration
         */
        CharacterLiteral(char value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.value);
        }

        @Override
        public int estimateLength() {
            return 1;
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String value;

        /*
         * WARNING - void declaration
         */
        StringLiteral(String value) {
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.value);
        }

        @Override
        public int estimateLength() {
            return this.value.length();
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int field;

        /*
         * WARNING - void declaration
         */
        UnpaddedNumberField(int field) {
            void var1_1;
            this.field = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.field));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            if (value < 100) {
                FastDatePrinter.access$000(buffer, value);
                return;
            }
            FastDatePrinter.access$100((Appendable)var1_1, (int)var2_2, 1);
        }

        @Override
        public int estimateLength() {
            return 4;
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int field;

        /*
         * WARNING - void declaration
         */
        TwoDigitNumberField(int field) {
            void var1_1;
            this.field = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.field));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            void var1_1;
            if (value < 100) {
                FastDatePrinter.access$000(buffer, value);
                return;
            }
            FastDatePrinter.access$100((Appendable)var1_1, (int)var2_2, 2);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static final class PaddedNumberField
    implements NumberRule {
        private final int field;
        private final int size;

        /*
         * WARNING - void declaration
         */
        PaddedNumberField(int field, int size) {
            void var2_2;
            void var1_1;
            if (size < 3) {
                throw new IllegalArgumentException();
            }
            this.field = var1_1;
            this.size = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            void var2_2;
            void var1_1;
            this.appendTo((Appendable)var1_1, var2_2.get(this.field));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            void var2_2;
            FastDatePrinter.access$100(buffer, (int)var2_2, this.size);
        }

        @Override
        public final int estimateLength() {
            return this.size;
        }
    }
}

