/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class CalendarUtils {
    public static final CalendarUtils INSTANCE = CalendarUtils.getInstance();
    private final Calendar calendar;
    private final Locale locale;

    public static CalendarUtils getInstance() {
        return new CalendarUtils(Calendar.getInstance());
    }

    static CalendarUtils getInstance(Locale locale) {
        Locale locale2;
        return new CalendarUtils(Calendar.getInstance(locale), locale2);
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        Calendar calendar2;
        return LocalDateTime.ofInstant(calendar.toInstant(), CalendarUtils.toZoneId(calendar2));
    }

    public static OffsetDateTime toOffsetDateTime(Calendar calendar) {
        Calendar calendar2;
        return OffsetDateTime.ofInstant(calendar.toInstant(), CalendarUtils.toZoneId(calendar2));
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        Calendar calendar2;
        return ZonedDateTime.ofInstant(calendar.toInstant(), CalendarUtils.toZoneId(calendar2));
    }

    private static ZoneId toZoneId(Calendar calendar) {
        return calendar.getTimeZone().toZoneId();
    }

    /*
     * WARNING - void declaration
     */
    public CalendarUtils(Calendar calendar) {
        this((Calendar)var1_1, Locale.getDefault());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    CalendarUtils(Calendar calendar, Locale locale) {
        void var2_2;
        void var1_1;
        this.calendar = (Calendar)Objects.requireNonNull(var1_1, "calendar");
        this.locale = (Locale)Objects.requireNonNull(var2_2, "locale");
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    /*
     * WARNING - void declaration
     */
    String[] getMonthDisplayNames(int style) {
        void var2_3;
        void var1_2;
        Map<String, Integer> displayNames = this.calendar.getDisplayNames(2, style, this.locale);
        if (displayNames == null) {
            return null;
        }
        String[] monthNames = new String[displayNames.size()];
        var1_2.forEach((k2, v2) -> {
            void var1_1;
            monthNames[var2_2.intValue()] = var1_1;
        });
        return var2_3;
    }

    String[] getStandaloneLongMonthNames() {
        return this.getMonthDisplayNames(32770);
    }

    String[] getStandaloneShortMonthNames() {
        return this.getMonthDisplayNames(32769);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public LocalDateTime toLocalDateTime() {
        return CalendarUtils.toLocalDateTime(this.calendar);
    }

    public OffsetDateTime toOffsetDateTime() {
        return CalendarUtils.toOffsetDateTime(this.calendar);
    }

    public ZonedDateTime toZonedDateTime() {
        return CalendarUtils.toZonedDateTime(this.calendar);
    }
}

